/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.handle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import magibridge.org.json.JSONArray;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.client.entities.CallUser;
import net.dv8tion.jda.client.entities.CallableChannel;
import net.dv8tion.jda.client.entities.impl.CallImpl;
import net.dv8tion.jda.client.entities.impl.CallUserImpl;
import net.dv8tion.jda.client.events.call.update.CallUpdateRegionEvent;
import net.dv8tion.jda.client.events.call.update.CallUpdateRingingUsersEvent;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;

public class CallUpdateHandler
extends SocketHandler {
    public CallUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long channelId = content.getLong("channel_id");
        JSONArray ringing = content.getJSONArray("ringing");
        Region region = Region.fromKey(content.getString("region"));
        CallableChannel channel = this.getJDA().asClient().getGroupById(channelId);
        if (channel == null) {
            channel = this.getJDA().getPrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a CALL_UPDATE for a Group/PrivateChannel that has not yet been cached. JSON: {}", (Object)content);
            return null;
        }
        CallImpl call = (CallImpl)channel.getCurrentCall();
        if (call == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CALL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a CALL_UPDATE for a Call that has not yet been cached. JSON: {}", (Object)content);
            return null;
        }
        if (!Objects.equals((Object)region, (Object)call.getRegion())) {
            Region oldRegion = call.getRegion();
            call.setRegion(region);
            this.getJDA().getEventManager().handle(new CallUpdateRegionEvent(this.getJDA(), this.responseNumber, call, oldRegion));
        }
        if (ringing.length() > 0) {
            List<Long> givenRingingIds = this.toLongList(ringing);
            ArrayList<CallUser> stoppedRingingUsers = new ArrayList<CallUser>();
            ArrayList<CallUser> startedRingingUsers = new ArrayList<CallUser>();
            for (CallUser cUser : call.getRingingUsers()) {
                long userId = cUser.getUser().getIdLong();
                if (!givenRingingIds.contains(userId)) {
                    ((CallUserImpl)cUser).setRinging(false);
                    stoppedRingingUsers.add(cUser);
                    continue;
                }
                givenRingingIds.remove(userId);
            }
            Iterator<Object> iterator = givenRingingIds.iterator();
            while (iterator.hasNext()) {
                long userId = (Long)iterator.next();
                CallUserImpl cUser = (CallUserImpl)call.getCallUserMap().get(userId);
                cUser.setRinging(true);
                startedRingingUsers.add(cUser);
            }
            if (stoppedRingingUsers.size() > 0 || startedRingingUsers.size() > 0) {
                this.getJDA().getEventManager().handle(new CallUpdateRingingUsersEvent(this.getJDA(), this.responseNumber, call, stoppedRingingUsers, startedRingingUsers));
            }
        }
        return null;
    }

    private List<Long> toLongList(JSONArray array) {
        ArrayList<Long> longs = new ArrayList<Long>();
        for (int i = 0; i < array.length(); ++i) {
            longs.add(array.getLong(i));
        }
        return longs;
    }
}

