/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.handle;

import magibridge.org.json.JSONObject;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.events.relationship.FriendAddedEvent;
import net.dv8tion.jda.client.events.relationship.FriendRequestReceivedEvent;
import net.dv8tion.jda.client.events.relationship.FriendRequestSentEvent;
import net.dv8tion.jda.client.events.relationship.UserBlockedEvent;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.WebSocketClient;

public class RelationshipAddHandler
extends SocketHandler {
    public RelationshipAddHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        Relationship relationship = this.getJDA().getEntityBuilder().createRelationship(content);
        if (relationship == null) {
            WebSocketClient.LOG.warn("Received a RELATIONSHIP_ADD with an unknown type! JSON: {}", (Object)content);
            return null;
        }
        switch (relationship.getType()) {
            case FRIEND: {
                this.getJDA().getEventManager().handle(new FriendAddedEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            case BLOCKED: {
                this.getJDA().getEventManager().handle(new UserBlockedEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            case INCOMING_FRIEND_REQUEST: {
                this.getJDA().getEventManager().handle(new FriendRequestReceivedEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            case OUTGOING_FRIEND_REQUEST: {
                this.getJDA().getEventManager().handle(new FriendRequestSentEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a RELATIONSHIP_ADD with an unknown type! JSON: {}", (Object)content);
                return null;
            }
        }
        this.getJDA().getEventCache().playbackCache(EventCache.Type.RELATIONSHIP, relationship.getUser().getIdLong());
        this.getJDA().getEventCache().playbackCache(EventCache.Type.USER, relationship.getUser().getIdLong());
        return null;
    }
}

