/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.handle;

import magibridge.org.json.JSONObject;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.events.relationship.FriendRemovedEvent;
import net.dv8tion.jda.client.events.relationship.FriendRequestCanceledEvent;
import net.dv8tion.jda.client.events.relationship.FriendRequestIgnoredEvent;
import net.dv8tion.jda.client.events.relationship.UserUnblockedEvent;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.WebSocketClient;

public class RelationshipRemoveHandler
extends SocketHandler {
    public RelationshipRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long userId = content.getLong("id");
        RelationshipType type = RelationshipType.fromKey(content.getInt("type"));
        if (type == RelationshipType.NO_RELATIONSHIP) {
            return null;
        }
        Relationship relationship = this.getJDA().asClient().getRelationshipById(userId, type);
        if (relationship == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.RELATIONSHIP, userId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a RELATIONSHIP_REMOVE for a relationship that was not yet cached! JSON: {}", (Object)content);
            return null;
        }
        this.getJDA().asClient().getRelationshipMap().remove(userId);
        if (relationship.getType() == RelationshipType.FRIEND) {
            if (this.getJDA().getGuildMap().valueCollection().stream().noneMatch(g -> ((GuildImpl)g).getMembersMap().containsKey(userId))) {
                UserImpl user = (UserImpl)this.getJDA().getUserMap().remove(userId);
                if (user.hasPrivateChannel()) {
                    PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                    user.setFake(true);
                    priv.setFake(true);
                    this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
                    this.getJDA().getFakePrivateChannelMap().put(priv.getIdLong(), priv);
                } else {
                    for (Group grp : this.getJDA().asClient().getGroups()) {
                        if (!grp.getNonFriendUsers().contains(user)) continue;
                        user.setFake(true);
                        this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
                        break;
                    }
                }
                this.getJDA().getEventCache().clear(EventCache.Type.USER, userId);
            }
        } else {
            User user = relationship.getUser();
            if (user.isFake() && !user.hasPrivateChannel() && this.getJDA().asClient().getGroups().stream().noneMatch(g -> g.getUsers().contains(user))) {
                this.getJDA().getFakeUserMap().remove(userId);
            }
        }
        switch (type) {
            case FRIEND: {
                this.getJDA().getEventManager().handle(new FriendRemovedEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            case BLOCKED: {
                this.getJDA().getEventManager().handle(new UserUnblockedEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            case INCOMING_FRIEND_REQUEST: {
                this.getJDA().getEventManager().handle(new FriendRequestIgnoredEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            case OUTGOING_FRIEND_REQUEST: {
                this.getJDA().getEventManager().handle(new FriendRequestCanceledEvent(this.getJDA(), this.responseNumber, relationship));
                break;
            }
            default: {
                WebSocketClient.LOG.warn("Received a RELATIONSHIP_REMOVE with an unknown RelationshipType! JSON: {}", (Object)content);
                return null;
            }
        }
        this.getJDA().getEventCache().clear(EventCache.Type.RELATIONSHIP, userId);
        return null;
    }
}

