/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.impl.ManagerBase;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.RequestBody;

public class EmoteManager
extends ManagerBase {
    public static final long NAME = 1L;
    public static final long ROLES = 2L;
    protected final EmoteImpl emote;
    protected final List<String> roles = new ArrayList<String>();
    protected String name;

    public EmoteManager(EmoteImpl emote) {
        super(emote.getJDA(), Route.Emotes.MODIFY_EMOTE.compile(EmoteManager.notNullGuild(emote).getId(), emote.getId()));
        this.emote = emote;
        if (EmoteManager.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    private static Guild notNullGuild(EmoteImpl emote) {
        GuildImpl g = emote.getGuild();
        if (g == null) {
            throw new IllegalStateException("Cannot modify a fake emote");
        }
        return g;
    }

    @Override
    public JDA getJDA() {
        return this.emote.getJDA();
    }

    public Guild getGuild() {
        return this.emote.getGuild();
    }

    public Emote getEmote() {
        return this.emote;
    }

    @Override
    @CheckReturnValue
    public EmoteManager reset(long fields) {
        super.reset(fields);
        if ((fields & 2L) == 2L) {
            this.withLock(this.roles, List::clear);
        }
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public EmoteManager reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    protected EmoteManager reset() {
        super.reset();
        this.withLock(this.roles, List::clear);
        this.name = null;
        return this;
    }

    @CheckReturnValue
    public EmoteManager setName(String name) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() >= 2 && name.length() <= 32, "Name must be between 2-32 characters long");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @CheckReturnValue
    public EmoteManager setRoles(Set<Role> roles) {
        if (roles == null) {
            this.withLock(this.roles, List::clear);
        } else {
            Checks.notNull(roles, "Roles");
            roles.forEach(role -> {
                Checks.notNull(role, "Roles");
                Checks.check(role.getGuild().equals(this.getGuild()), "Roles must all be from the same guild");
            });
            this.withLock(this.roles, list -> {
                list.clear();
                roles.stream().map(ISnowflake::getId).forEach(list::add);
            });
        }
        this.set |= 2L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        if (this.shouldUpdate(1L)) {
            object.put("name", this.name);
        }
        this.withLock(this.roles, list -> {
            if (this.shouldUpdate(2L)) {
                object.put("roles", (Collection<?>)list);
            }
        });
        this.reset();
        return this.getRequestBody(object);
    }

    @Override
    protected boolean checkPermissions() {
        if (!this.getGuild().getSelfMember().hasPermission(Permission.MANAGE_EMOTES)) {
            throw new InsufficientPermissionException(Permission.MANAGE_EMOTES);
        }
        return super.checkPermissions();
    }
}

