/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formattable;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.CheckReturnValue;
import magibridge.org.json.JSONArray;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageHistory;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.RequestFuture;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.requests.restaction.MessageAction;
import net.dv8tion.jda.core.requests.restaction.pagination.MessagePaginationAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;

public interface MessageChannel
extends ISnowflake,
Formattable {
    default public String getLatestMessageId() {
        return Long.toUnsignedString(this.getLatestMessageIdLong());
    }

    default public List<RequestFuture<Void>> purgeMessagesById(List<String> messageIds) {
        if (messageIds == null || messageIds.isEmpty()) {
            return Collections.emptyList();
        }
        long[] ids = new long[messageIds.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = MiscUtil.parseSnowflake(messageIds.get(i));
        }
        return this.purgeMessagesById(ids);
    }

    default public List<RequestFuture<Void>> purgeMessagesById(String ... messageIds) {
        if (messageIds == null || messageIds.length == 0) {
            return Collections.emptyList();
        }
        return this.purgeMessagesById(Arrays.asList(messageIds));
    }

    default public List<RequestFuture<Void>> purgeMessages(Message ... messages) {
        if (messages == null || messages.length == 0) {
            return Collections.emptyList();
        }
        return this.purgeMessages(Arrays.asList(messages));
    }

    default public List<RequestFuture<Void>> purgeMessages(List<? extends Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return Collections.emptyList();
        }
        long[] ids = new long[messages.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = messages.get(i).getIdLong();
        }
        return this.purgeMessagesById(ids);
    }

    default public List<RequestFuture<Void>> purgeMessagesById(long ... messageIds) {
        if (messageIds == null || messageIds.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<RequestFuture<Void>> list = new ArrayList<RequestFuture<Void>>(messageIds.length);
        TreeSet sortedIds = new TreeSet(Comparator.reverseOrder());
        for (long messageId : messageIds) {
            sortedIds.add(messageId);
        }
        Object object = sortedIds.iterator();
        while (object.hasNext()) {
            long messageId = (Long)object.next();
            list.add(this.deleteMessageById(messageId).submit());
        }
        return list;
    }

    public long getLatestMessageIdLong();

    public boolean hasLatestMessage();

    public String getName();

    public ChannelType getType();

    public JDA getJDA();

    @CheckReturnValue
    default public MessageAction sendMessage(CharSequence text) {
        Checks.notEmpty(text, "Provided text for message");
        Checks.check(text.length() <= 2000, "Provided text for message must be less than 2000 characters in length");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        if (text instanceof StringBuilder) {
            return new MessageAction(this.getJDA(), route, this, (StringBuilder)text);
        }
        return new MessageAction(this.getJDA(), route, this).append(text);
    }

    @CheckReturnValue
    default public MessageAction sendMessageFormat(String format, Object ... args) {
        Checks.notEmpty(format, "Format");
        return this.sendMessage(String.format(format, args));
    }

    @CheckReturnValue
    default public MessageAction sendMessage(MessageEmbed embed) {
        Checks.notNull(embed, "Provided embed");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        return new MessageAction(this.getJDA(), route, this).embed(embed);
    }

    @CheckReturnValue
    default public MessageAction sendMessage(Message msg) {
        Checks.notNull(msg, "Message");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        return new MessageAction(this.getJDA(), route, this).apply(msg);
    }

    @CheckReturnValue
    default public MessageAction sendFile(File file) {
        return this.sendFile(file, (Message)null);
    }

    @CheckReturnValue
    default public MessageAction sendFile(File file, String fileName) {
        return this.sendFile(file, fileName, null);
    }

    @CheckReturnValue
    default public MessageAction sendFile(InputStream data, String fileName) {
        return this.sendFile(data, fileName, null);
    }

    @CheckReturnValue
    default public MessageAction sendFile(byte[] data, String fileName) {
        return this.sendFile(data, fileName, null);
    }

    @CheckReturnValue
    default public MessageAction sendFile(File file, Message message) {
        Checks.notNull(file, "file");
        return this.sendFile(file, file.getName(), message);
    }

    @CheckReturnValue
    default public MessageAction sendFile(File file, String fileName, Message message) {
        Checks.notNull(file, "file");
        Checks.check(file.exists() && file.canRead(), "Provided file is either null, doesn't exist or is not readable!");
        Checks.check(file.length() <= this.getJDA().getSelfUser().getAllowedFileSize(), "File is too big! Max file-size is 8 MiB for normal and 50 MiB for nitro users");
        Checks.notNull(fileName, "fileName");
        try {
            return this.sendFile(new FileInputStream(file), fileName, message);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @CheckReturnValue
    default public MessageAction sendFile(InputStream data, String fileName, Message message) {
        Checks.notNull(data, "data InputStream");
        Checks.notNull(fileName, "fileName");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        return new MessageAction(this.getJDA(), route, this).apply(message).addFile(data, fileName);
    }

    @CheckReturnValue
    default public MessageAction sendFile(byte[] data, String fileName, Message message) {
        Checks.notNull(data, "data");
        Checks.notNull(fileName, "fileName");
        long maxSize = this.getJDA().getSelfUser().getAllowedFileSize();
        Checks.check((long)data.length <= maxSize, "File is too big! Max file-size is %d bytes", (Object)maxSize);
        return this.sendFile(new ByteArrayInputStream(data), fileName, message);
    }

    @CheckReturnValue
    default public RestAction<Message> getMessageById(String messageId) {
        AccountTypeException.check(this.getJDA().getAccountType(), AccountType.BOT);
        Checks.isSnowflake(messageId, "Message ID");
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Message> request) {
                if (response.isOk()) {
                    Message m = ((JDAImpl)this.api.get()).getEntityBuilder().createMessage(response.getObject(), MessageChannel.this, false);
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Message> getMessageById(long messageId) {
        return this.getMessageById(Long.toUnsignedString(messageId));
    }

    @CheckReturnValue
    default public AuditableRestAction<Void> deleteMessageById(String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getId(), messageId);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public AuditableRestAction<Void> deleteMessageById(long messageId) {
        return this.deleteMessageById(Long.toUnsignedString(messageId));
    }

    default public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    @CheckReturnValue
    default public MessagePaginationAction getIterableHistory() {
        return new MessagePaginationAction(this);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAround(String messageId, int limit) {
        return MessageHistory.getHistoryAround(this, messageId).limit(limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAround(long messageId, int limit) {
        return this.getHistoryAround(Long.toUnsignedString(messageId), limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAround(Message message, int limit) {
        Checks.notNull(message, "Provided target message");
        return this.getHistoryAround(message.getId(), limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAfter(String messageId, int limit) {
        return MessageHistory.getHistoryAfter(this, messageId).limit(limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAfter(long messageId, int limit) {
        return this.getHistoryAfter(Long.toUnsignedString(messageId), limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryAfter(Message message, int limit) {
        Checks.notNull(message, "Message");
        return this.getHistoryAfter(message.getId(), limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryBefore(String messageId, int limit) {
        return MessageHistory.getHistoryBefore(this, messageId).limit(limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryBefore(long messageId, int limit) {
        return this.getHistoryBefore(Long.toUnsignedString(messageId), limit);
    }

    @CheckReturnValue
    default public MessageHistory.MessageRetrieveAction getHistoryBefore(Message message, int limit) {
        Checks.notNull(message, "Message");
        return this.getHistoryBefore(message.getId(), limit);
    }

    @CheckReturnValue
    default public RestAction<Void> sendTyping() {
        Route.CompiledRoute route = Route.Channels.SEND_TYPING.compile(this.getId());
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(String messageId, String unicode) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notEmpty(unicode, "Provided Unicode");
        Checks.noWhitespace(unicode, "Provided Unicode");
        String encoded = MiscUtil.encodeUTF8(unicode);
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, encoded);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(long messageId, String unicode) {
        return this.addReactionById(Long.toUnsignedString(messageId), unicode);
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(String messageId, Emote emote) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(emote, "Emote");
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, String.format("%s:%s", emote.getName(), emote.getId()));
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> addReactionById(long messageId, Emote emote) {
        return this.addReactionById(Long.toUnsignedString(messageId), emote);
    }

    @CheckReturnValue
    default public RestAction<Void> removeReactionById(String messageId, String unicode) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.noWhitespace(unicode, "Emoji");
        String code = MiscUtil.encodeUTF8(unicode);
        Route.CompiledRoute route = Route.Messages.REMOVE_OWN_REACTION.compile(this.getId(), messageId, code);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                } else {
                    request.onSuccess(null);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> removeReactionById(long messageId, String unicode) {
        return this.removeReactionById(Long.toUnsignedString(messageId), unicode);
    }

    @CheckReturnValue
    default public RestAction<Void> removeReactionById(String messageId, Emote emote) {
        Checks.notNull(emote, "Emote");
        return this.removeReactionById(messageId, emote.getName() + ":" + emote.getId());
    }

    @CheckReturnValue
    default public RestAction<Void> removeReactionById(long messageId, Emote emote) {
        Checks.notNull(emote, "Emote");
        return this.removeReactionById(messageId, emote.getName() + ":" + emote.getId());
    }

    @CheckReturnValue
    default public RestAction<Void> pinMessageById(String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> pinMessageById(long messageId) {
        return this.pinMessageById(Long.toUnsignedString(messageId));
    }

    @CheckReturnValue
    default public RestAction<Void> unpinMessageById(String messageId) {
        Checks.isSnowflake(messageId, "Message ID");
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public RestAction<Void> unpinMessageById(long messageId) {
        return this.unpinMessageById(Long.toUnsignedString(messageId));
    }

    @CheckReturnValue
    default public RestAction<List<Message>> getPinnedMessages() {
        Route.CompiledRoute route = Route.Messages.GET_PINNED_MESSAGES.compile(this.getId());
        return new RestAction<List<Message>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Message>> request) {
                if (response.isOk()) {
                    LinkedList<Message> pinnedMessages = new LinkedList<Message>();
                    EntityBuilder builder = ((JDAImpl)this.api.get()).getEntityBuilder();
                    JSONArray pins = response.getArray();
                    for (int i = 0; i < pins.length(); ++i) {
                        pinnedMessages.add(builder.createMessage(pins.getJSONObject(i), MessageChannel.this, false));
                    }
                    request.onSuccess(Collections.unmodifiableList(pinnedMessages));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @CheckReturnValue
    default public MessageAction editMessageById(String messageId, CharSequence newContent) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notEmpty(newContent, "Provided message content");
        Checks.check(newContent.length() <= 2000, "Provided newContent length must be 2000 or less characters.");
        Route.CompiledRoute route = Route.Messages.EDIT_MESSAGE.compile(this.getId(), messageId);
        if (newContent instanceof StringBuilder) {
            return new MessageAction(this.getJDA(), route, this, (StringBuilder)newContent);
        }
        return new MessageAction(this.getJDA(), route, this).append(newContent);
    }

    @CheckReturnValue
    default public MessageAction editMessageById(long messageId, CharSequence newContent) {
        return this.editMessageById(Long.toUnsignedString(messageId), newContent);
    }

    @CheckReturnValue
    default public MessageAction editMessageById(String messageId, Message newContent) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(newContent, "message");
        Route.CompiledRoute route = Route.Messages.EDIT_MESSAGE.compile(this.getId(), messageId);
        return new MessageAction(this.getJDA(), route, this).apply(newContent);
    }

    @CheckReturnValue
    default public MessageAction editMessageById(long messageId, Message newContent) {
        return this.editMessageById(Long.toUnsignedString(messageId), newContent);
    }

    @CheckReturnValue
    default public MessageAction editMessageFormatById(String messageId, String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessageById(messageId, (CharSequence)String.format(format, args));
    }

    @CheckReturnValue
    default public MessageAction editMessageFormatById(long messageId, String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessageById(messageId, (CharSequence)String.format(format, args));
    }

    @CheckReturnValue
    default public MessageAction editMessageById(String messageId, MessageEmbed newEmbed) {
        Checks.isSnowflake(messageId, "Message ID");
        Checks.notNull(newEmbed, "MessageEmbed");
        Route.CompiledRoute route = Route.Messages.EDIT_MESSAGE.compile(this.getId(), messageId);
        return new MessageAction(this.getJDA(), route, this).embed(newEmbed);
    }

    @CheckReturnValue
    default public MessageAction editMessageById(long messageId, MessageEmbed newEmbed) {
        return this.editMessageById(Long.toUnsignedString(messageId), newEmbed);
    }

    @Override
    default public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String out;
        boolean leftJustified = (flags & 1) == 1;
        boolean upper = (flags & 2) == 2;
        boolean alt = (flags & 4) == 4;
        String string = out = upper ? this.getName().toUpperCase(formatter.locale()) : this.getName();
        if (alt) {
            out = "#" + out;
        }
        MiscUtil.appendTo(formatter, width, precision, leftJustified, out);
    }
}

