/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import magibridge.org.json.JSONObject;
import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.events.group.GroupLeaveEvent;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.channel.category.CategoryDeleteEvent;
import net.dv8tion.jda.core.events.channel.priv.PrivateChannelDeleteEvent;
import net.dv8tion.jda.core.events.channel.text.TextChannelDeleteEvent;
import net.dv8tion.jda.core.events.channel.voice.VoiceChannelDeleteEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.WebSocketClient;

public class ChannelDeleteHandler
extends SocketHandler {
    public ChannelDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        long channelId = content.getLong("id");
        switch (type) {
            case TEXT: {
                GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
                TextChannel channel = this.getJDA().getTextChannelMap().remove(channelId);
                if (channel == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a text channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getTextChannelsMap().remove(channel.getIdLong());
                this.getJDA().getEventManager().handle(new TextChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case VOICE: {
                GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
                VoiceChannel channel = this.getJDA().getVoiceChannelMap().remove(channelId);
                if (channel == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a voice channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                AudioManagerImpl manager = (AudioManagerImpl)this.getJDA().getAudioManagerMap().get(guild.getIdLong());
                if (manager != null && manager.isConnected() && manager.getConnectedChannel().getIdLong() == channel.getIdLong()) {
                    manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_CHANNEL_DELETED);
                }
                guild.getVoiceChannelsMap().remove(channel.getIdLong());
                this.getJDA().getEventManager().handle(new VoiceChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case CATEGORY: {
                GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
                Category category = this.getJDA().getCategoryMap().remove(channelId);
                if (category == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a category channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                guild.getCategoriesMap().remove(channelId);
                this.getJDA().getEventManager().handle(new CategoryDeleteEvent(this.getJDA(), this.responseNumber, category));
                break;
            }
            case PRIVATE: {
                PrivateChannel channel = this.getJDA().getPrivateChannelMap().remove(channelId);
                if (channel == null) {
                    channel = this.getJDA().getFakePrivateChannelMap().remove(channelId);
                }
                if (channel == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a private channel that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                if (channel.getUser().isFake()) {
                    this.getJDA().getFakeUserMap().remove(channel.getUser().getIdLong());
                }
                ((UserImpl)channel.getUser()).setPrivateChannel(null);
                this.getJDA().getEventManager().handle(new PrivateChannelDeleteEvent(this.getJDA(), this.responseNumber, channel));
                break;
            }
            case GROUP: {
                long groupId = content.getLong("id");
                GroupImpl group = (GroupImpl)this.getJDA().asClient().getGroupMap().remove(groupId);
                if (group == null) {
                    WebSocketClient.LOG.debug("CHANNEL_DELETE attempted to delete a group that is not yet cached. JSON: {}", (Object)content);
                    return null;
                }
                group.getUserMap().forEachEntry((userId, user) -> {
                    if (user.isFake() && !user.hasPrivateChannel() && this.getJDA().asClient().getRelationshipMap().get(userId) == null && this.getJDA().asClient().getGroups().stream().noneMatch(g -> g.getUsers().contains(user))) {
                        this.getJDA().getFakeUserMap().remove(userId);
                    }
                    return true;
                });
                this.getJDA().getEventManager().handle(new GroupLeaveEvent(this.getJDA(), this.responseNumber, group));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_DELETE provided an unknown channel type. JSON: " + content);
            }
        }
        this.getJDA().getEventCache().clear(EventCache.Type.CHANNEL, channelId);
        return null;
    }
}

