/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import magibridge.gnu.trove.iterator.TLongIterator;
import magibridge.gnu.trove.map.TLongObjectMap;
import magibridge.gnu.trove.set.hash.TLongHashSet;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.core.events.guild.GuildUnavailableEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.WebSocketClient;
import net.dv8tion.jda.core.utils.Helpers;
import net.dv8tion.jda.core.utils.MiscUtil;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long handleInternally(JSONObject content) {
        TLongObjectMap<AudioManager> audioManagerMap;
        long id = content.getLong("id");
        boolean wasInit = this.getJDA().getGuildSetupController().onDelete(id, content);
        if (wasInit) {
            return null;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(id);
        boolean unavailable = Helpers.optBoolean(content, "unavailable");
        if (guild == null) {
            WebSocketClient.LOG.debug("Received GUILD_DELETE for a Guild that is not currently cached. ID: {} unavailable: {}", (Object)id, (Object)unavailable);
            return null;
        }
        if (!guild.isAvailable() && unavailable) {
            return null;
        }
        if (unavailable) {
            guild.setAvailable(false);
            this.getJDA().getEventManager().handle(new GuildUnavailableEvent(this.getJDA(), this.responseNumber, guild));
            return null;
        }
        this.getJDA().getGuildMap().remove(id);
        guild.getTextChannelCache().forEach(chan -> this.getJDA().getTextChannelMap().remove(chan.getIdLong()));
        guild.getVoiceChannelCache().forEach(chan -> this.getJDA().getVoiceChannelMap().remove(chan.getIdLong()));
        guild.getCategoryCache().forEach(chan -> this.getJDA().getCategoryMap().remove(chan.getIdLong()));
        this.getJDA().getClient().removeAudioConnection(id);
        TLongObjectMap<AudioManager> tLongObjectMap = audioManagerMap = this.getJDA().getAudioManagerMap();
        synchronized (tLongObjectMap) {
            AudioManagerImpl manager = (AudioManagerImpl)audioManagerMap.get(id);
            if (manager != null) {
                MiscUtil.locked(manager.CONNECTION_LOCK, () -> {
                    if (manager.isConnected() || manager.isAttemptingToConnect()) {
                        manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
                    } else {
                        audioManagerMap.remove(id);
                    }
                });
            }
        }
        TLongHashSet memberIds = new TLongHashSet(guild.getMembersMap().keySet());
        this.getJDA().getGuildCache().stream().map(GuildImpl.class::cast).forEach(g -> memberIds.removeAll(g.getMembersMap().keySet()));
        if (this.getJDA().getAccountType() == AccountType.CLIENT) {
            TLongObjectMap<Relationship> relationships = this.getJDA().asClient().getRelationshipMap();
            TLongIterator it = memberIds.iterator();
            while (it.hasNext()) {
                Relationship rel = relationships.get(it.next());
                if (rel == null || rel.getType() != RelationshipType.FRIEND) continue;
                it.remove();
            }
        }
        long selfId = this.getJDA().getSelfUser().getIdLong();
        memberIds.forEach(memberId -> {
            if (memberId == selfId) {
                return true;
            }
            UserImpl user = (UserImpl)this.getJDA().getUserMap().remove(memberId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
                this.getJDA().getFakePrivateChannelMap().put(priv.getIdLong(), priv);
            } else if (this.getJDA().getAccountType() == AccountType.CLIENT) {
                for (Group grp : this.getJDA().asClient().getGroups()) {
                    if (!grp.getNonFriendUsers().contains(user)) continue;
                    user.setFake(true);
                    this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
                    break;
                }
            }
            this.getJDA().getEventCache().clear(EventCache.Type.USER, memberId);
            return true;
        });
        this.getJDA().getEventManager().handle(new GuildLeaveEvent(this.getJDA(), this.responseNumber, guild));
        this.getJDA().getEventCache().clear(EventCache.Type.GUILD, id);
        return null;
    }
}

