/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import magibridge.gnu.trove.map.TLongObjectMap;
import magibridge.org.apache.commons.collections4.CollectionUtils;
import magibridge.org.json.JSONArray;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.emote.EmoteAddedEvent;
import net.dv8tion.jda.core.events.emote.EmoteRemovedEvent;
import net.dv8tion.jda.core.events.emote.update.EmoteUpdateNameEvent;
import net.dv8tion.jda.core.events.emote.update.EmoteUpdateRolesEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.utils.cache.CacheFlag;

public class GuildEmojisUpdateHandler
extends SocketHandler {
    public GuildEmojisUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        if (!this.getJDA().isCacheFlagSet(CacheFlag.EMOTE)) {
            return null;
        }
        long guildId = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            return null;
        }
        JSONArray array = content.getJSONArray("emojis");
        TLongObjectMap<Emote> emoteMap = guild.getEmoteMap();
        ArrayList<Emote> oldEmotes = new ArrayList<Emote>(emoteMap.valueCollection());
        ArrayList<EmoteImpl> newEmotes = new ArrayList<EmoteImpl>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jSONObject = array.getJSONObject(i);
            long emoteId = jSONObject.getLong("id");
            EmoteImpl emote = (EmoteImpl)emoteMap.get(emoteId);
            EmoteImpl oldEmote = null;
            if (emote == null) {
                emote = new EmoteImpl(emoteId, guild);
                newEmotes.add(emote);
            } else {
                oldEmotes.remove(emote);
                oldEmote = emote.clone();
            }
            emote.setName(jSONObject.getString("name")).setAnimated(jSONObject.optBoolean("animated")).setManaged(jSONObject.getBoolean("managed"));
            JSONArray roles = jSONObject.getJSONArray("roles");
            Set<Role> newRoles = emote.getRoleSet();
            HashSet<Role> oldRoles = new HashSet<Role>(newRoles);
            for (int j = 0; j < roles.length(); ++j) {
                Role role = guild.getRoleById(roles.getString(j));
                if (role == null) continue;
                newRoles.add(role);
                oldRoles.remove(role);
            }
            for (Role r : oldRoles) {
                newRoles.remove(r);
            }
            emoteMap.put(emote.getIdLong(), emote);
            this.handleReplace(oldEmote, emote);
        }
        for (Emote emote : oldEmotes) {
            emoteMap.remove(emote.getIdLong());
            this.getJDA().getEventManager().handle(new EmoteRemovedEvent(this.getJDA(), this.responseNumber, emote));
        }
        for (Emote emote : newEmotes) {
            this.getJDA().getEventManager().handle(new EmoteAddedEvent(this.getJDA(), this.responseNumber, emote));
        }
        return null;
    }

    private void handleReplace(Emote oldEmote, Emote newEmote) {
        if (oldEmote == null || newEmote == null) {
            return;
        }
        if (!Objects.equals(oldEmote.getName(), newEmote.getName())) {
            this.getJDA().getEventManager().handle(new EmoteUpdateNameEvent(this.getJDA(), this.responseNumber, newEmote, oldEmote.getName()));
        }
        if (!CollectionUtils.isEqualCollection(oldEmote.getRoles(), newEmote.getRoles())) {
            this.getJDA().getEventManager().handle(new EmoteUpdateRolesEvent(this.getJDA(), this.responseNumber, newEmote, oldEmote.getRoles()));
        }
    }
}

