/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import magibridge.org.json.JSONObject;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.GuildVoiceStateImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.events.guild.member.GuildMemberLeaveEvent;
import net.dv8tion.jda.core.events.guild.voice.GuildVoiceLeaveEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.WebSocketClient;

public class GuildMemberRemoveHandler
extends SocketHandler {
    public GuildMemberRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long id = content.getLong("guild_id");
        boolean setup = this.getJDA().getGuildSetupController().onRemoveMember(id, content);
        if (setup) {
            return null;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(id);
        if (guild == null) {
            return null;
        }
        long userId = content.getJSONObject("user").getLong("id");
        if (userId == this.getJDA().getSelfUser().getIdLong()) {
            return null;
        }
        MemberImpl member = (MemberImpl)guild.getMembersMap().remove(userId);
        if (member == null) {
            WebSocketClient.LOG.debug("Received GUILD_MEMBER_REMOVE for a Member that does not exist in the specified Guild.");
            return null;
        }
        GuildVoiceStateImpl voiceState = (GuildVoiceStateImpl)member.getVoiceState();
        if (voiceState != null && voiceState.inVoiceChannel()) {
            VoiceChannel channel = voiceState.getChannel();
            voiceState.setConnectedChannel(null);
            ((VoiceChannelImpl)channel).getConnectedMembersMap().remove(member.getUser().getIdLong());
            this.getJDA().getEventManager().handle(new GuildVoiceLeaveEvent(this.getJDA(), this.responseNumber, member, channel));
        }
        if (userId != this.getJDA().getSelfUser().getIdLong() && this.getJDA().getGuildMap().valueCollection().stream().noneMatch(g -> ((GuildImpl)g).getMembersMap().containsKey(userId)) && (this.getJDA().getAccountType() != AccountType.CLIENT || this.getJDA().asClient().getFriendById(userId) == null)) {
            UserImpl user = (UserImpl)this.getJDA().getUserMap().remove(userId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
                this.getJDA().getFakePrivateChannelMap().put(priv.getIdLong(), priv);
            } else if (this.getJDA().getAccountType() == AccountType.CLIENT) {
                for (Group grp : this.getJDA().asClient().getGroups()) {
                    if (!grp.getNonFriendUsers().contains(user)) continue;
                    user.setFake(true);
                    this.getJDA().getFakeUserMap().put(user.getIdLong(), user);
                    break;
                }
            }
            this.getJDA().getEventCache().clear(EventCache.Type.USER, userId);
        }
        this.getJDA().getEventManager().handle(new GuildMemberLeaveEvent((JDA)this.getJDA(), this.responseNumber, member));
        return null;
    }
}

