/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.role.RoleCreateEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;

public class GuildRoleCreateHandler
extends SocketHandler {
    public GuildRoleCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long guildId = content.getLong("guild_id");
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(guildId);
        if (guild == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("GUILD_ROLE_CREATE was received for a Guild that is not yet cached: {}", (Object)content);
            return null;
        }
        Role newRole = this.getJDA().getEntityBuilder().createRole(guild, content.getJSONObject("role"), guild.getIdLong());
        this.getJDA().getEventManager().handle(new RoleCreateEvent(this.getJDA(), this.responseNumber, newRole));
        return null;
    }
}

