/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import magibridge.gnu.trove.iterator.TLongIterator;
import magibridge.gnu.trove.iterator.TLongObjectIterator;
import magibridge.gnu.trove.map.TLongObjectMap;
import magibridge.gnu.trove.map.hash.TLongObjectHashMap;
import magibridge.gnu.trove.set.TLongSet;
import magibridge.gnu.trove.set.hash.TLongHashSet;
import magibridge.org.json.JSONArray;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.audio.hooks.ConnectionListener;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.guild.GuildJoinEvent;
import net.dv8tion.jda.core.events.guild.GuildReadyEvent;
import net.dv8tion.jda.core.events.guild.UnavailableGuildJoinedEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.GuildSetupController;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.utils.Helpers;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;

public class GuildSetupNode {
    private final long id;
    private final UpstreamReference<GuildSetupController> controller;
    private final List<JSONObject> cachedEvents = new LinkedList<JSONObject>();
    private TLongObjectMap<JSONObject> members;
    private TLongSet removedMembers;
    private JSONObject partialGuild;
    private int expectedMemberCount = 1;
    private boolean requestedSync;
    boolean requestedChunk;
    final boolean join;
    final boolean sync;
    boolean firedUnavailableJoin = false;
    boolean markedUnavailable = false;
    GuildSetupController.Status status = GuildSetupController.Status.INIT;

    GuildSetupNode(long id, GuildSetupController controller, boolean join) {
        this.id = id;
        this.controller = new UpstreamReference<GuildSetupController>(controller);
        this.join = join;
        this.sync = controller.isClient();
    }

    public long getIdLong() {
        return this.id;
    }

    public String getId() {
        return Long.toUnsignedString(this.id);
    }

    @Nullable
    public JSONObject getGuildPayload() {
        return this.partialGuild;
    }

    public int getExpectedMemberCount() {
        return this.expectedMemberCount;
    }

    public int getCurrentMemberCount() {
        TLongHashSet knownMembers = new TLongHashSet(this.members.keySet());
        knownMembers.removeAll(this.removedMembers);
        return knownMembers.size();
    }

    public boolean isJoin() {
        return this.join;
    }

    public boolean isMarkedUnavailable() {
        return this.markedUnavailable;
    }

    public boolean requestedChunks() {
        return this.requestedChunk;
    }

    public boolean requestedSync() {
        return this.requestedSync;
    }

    public boolean containsMember(long userId) {
        if (this.members == null || this.members.isEmpty()) {
            return false;
        }
        return this.members.containsKey(userId);
    }

    public String toString() {
        return "GuildSetupNode[" + this.id + "|" + (Object)((Object)this.status) + ']' + '{' + "expectedMemberCount=" + this.expectedMemberCount + ", requestedSync=" + this.requestedSync + ", requestedChunk=" + this.requestedChunk + ", join=" + this.join + ", sync=" + this.sync + ", markedUnavailable=" + this.markedUnavailable + '}';
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuildSetupNode)) {
            return false;
        }
        GuildSetupNode node = (GuildSetupNode)obj;
        return node.id == this.id;
    }

    private GuildSetupController getController() {
        return this.controller.get();
    }

    void updateStatus(GuildSetupController.Status status) {
        if (status == this.status) {
            return;
        }
        try {
            this.getController().listener.onStatusChange(this.id, this.status, status);
        }
        catch (Exception ex) {
            GuildSetupController.log.error("Uncaught exception in status listener", (Throwable)ex);
        }
        this.status = status;
    }

    void reset() {
        this.updateStatus(GuildSetupController.Status.UNAVAILABLE);
        this.expectedMemberCount = 1;
        this.partialGuild = null;
        this.requestedChunk = false;
        this.requestedSync = false;
        if (this.members != null) {
            this.members.clear();
        }
        if (this.removedMembers != null) {
            this.removedMembers.clear();
        }
        this.cachedEvents.clear();
    }

    void handleReady(JSONObject obj) {
        if (!this.sync) {
            return;
        }
        this.partialGuild = obj;
        this.markedUnavailable = Helpers.optBoolean(this.partialGuild, "unavailable");
        if (this.markedUnavailable) {
            this.updateStatus(GuildSetupController.Status.UNAVAILABLE);
        } else {
            this.getController().addGuildForSyncing(this.id, this.join);
            this.requestedSync = true;
        }
    }

    void handleCreate(JSONObject obj) {
        if (this.partialGuild == null) {
            this.partialGuild = obj;
        } else {
            Iterator<String> it = obj.keys();
            while (it.hasNext()) {
                String key = it.next();
                this.partialGuild.put(key, obj.opt(key));
            }
        }
        boolean unavailable = Helpers.optBoolean(this.partialGuild, "unavailable");
        boolean wasMarkedUnavailable = this.markedUnavailable;
        this.markedUnavailable = unavailable;
        if (unavailable) {
            if (!this.firedUnavailableJoin && this.join) {
                this.firedUnavailableJoin = true;
                JDAImpl api = this.getController().getJDA();
                api.getEventManager().handle(new UnavailableGuildJoinedEvent(api, api.getResponseTotal(), this.id));
            }
            return;
        }
        if (wasMarkedUnavailable && this.sync && !this.requestedSync) {
            this.updateStatus(GuildSetupController.Status.SYNCING);
            this.getController().addGuildForSyncing(this.id, this.join);
            this.requestedSync = true;
            return;
        }
        this.ensureMembers();
    }

    void handleSync(JSONObject obj) {
        if (this.partialGuild == null) {
            GuildSetupController.log.debug("Dropping sync update due to unavailable guild");
            return;
        }
        Iterator<String> it = obj.keys();
        while (it.hasNext()) {
            String key = it.next();
            this.partialGuild.put(key, obj.opt(key));
        }
        this.ensureMembers();
    }

    boolean handleMemberChunk(JSONArray arr) {
        if (this.partialGuild == null) {
            GuildSetupController.log.debug("Dropping member chunk due to unavailable guild");
            return true;
        }
        for (Object o : arr) {
            JSONObject obj = (JSONObject)o;
            long id = obj.getJSONObject("user").getLong("id");
            this.members.put(id, obj);
        }
        if (this.members.size() >= this.expectedMemberCount) {
            this.completeSetup();
            return false;
        }
        return true;
    }

    void handleAddMember(JSONObject member) {
        if (this.members == null || this.removedMembers == null) {
            return;
        }
        ++this.expectedMemberCount;
        long userId = member.getJSONObject("user").getLong("id");
        this.members.put(userId, member);
        this.removedMembers.remove(userId);
    }

    void handleRemoveMember(JSONObject member) {
        if (this.members == null || this.removedMembers == null) {
            return;
        }
        --this.expectedMemberCount;
        long userId = member.getJSONObject("user").getLong("id");
        this.members.remove(userId);
        this.removedMembers.add(userId);
        EventCache eventCache = this.getController().getJDA().getEventCache();
        if (!this.getController().containsMember(userId, this)) {
            eventCache.clear(EventCache.Type.USER, userId);
        }
    }

    void cacheEvent(JSONObject event) {
        GuildSetupController.log.trace("Caching {} event during init. GuildId: {}", (Object)event.getString("t"), (Object)this.id);
        this.cachedEvents.add(event);
        int cacheSize = this.cachedEvents.size();
        if (cacheSize >= 2000 && cacheSize % 1000 == 0) {
            GuildSetupController.log.warn("Accumulating suspicious amounts of cached events during guild setup, something might be wrong. Cached: {} GuildId: {}", (Object)cacheSize, (Object)this.id);
        }
    }

    void cleanup() {
        long id;
        JSONObject json;
        this.updateStatus(GuildSetupController.Status.REMOVED);
        EventCache eventCache = this.getController().getJDA().getEventCache();
        eventCache.clear(EventCache.Type.GUILD, this.id);
        if (this.partialGuild == null) {
            return;
        }
        JSONArray channels = this.partialGuild.optJSONArray("channels");
        JSONArray roles = this.partialGuild.optJSONArray("roles");
        if (channels != null) {
            for (Object o : channels) {
                json = (JSONObject)o;
                id = json.getLong("id");
                eventCache.clear(EventCache.Type.CHANNEL, id);
            }
        }
        if (roles != null) {
            for (Object o : roles) {
                json = (JSONObject)o;
                id = json.getLong("id");
                eventCache.clear(EventCache.Type.ROLE, id);
            }
        }
        if (this.members != null) {
            TLongObjectIterator<JSONObject> it = this.members.iterator();
            while (it.hasNext()) {
                it.advance();
                long userId = it.key();
                if (this.getController().containsMember(userId, this)) continue;
                eventCache.clear(EventCache.Type.USER, userId);
            }
        }
    }

    private void completeSetup() {
        this.updateStatus(GuildSetupController.Status.BUILDING);
        JDAImpl api = this.getController().getJDA();
        TLongIterator it = this.removedMembers.iterator();
        while (it.hasNext()) {
            this.members.remove(it.next());
        }
        this.removedMembers.clear();
        GuildImpl guild = api.getEntityBuilder().createGuild(this.id, this.partialGuild, this.members);
        this.updateAudioManagerReference(guild);
        if (this.join) {
            api.getEventManager().handle(new GuildJoinEvent(api, api.getResponseTotal(), guild));
            if (this.requestedChunk) {
                this.getController().ready(this.id);
            } else {
                this.getController().remove(this.id);
            }
        } else {
            api.getEventManager().handle(new GuildReadyEvent(api, api.getResponseTotal(), guild));
            this.getController().ready(this.id);
        }
        this.updateStatus(GuildSetupController.Status.READY);
        GuildSetupController.log.debug("Finished setup for guild {} firing cached events {}", (Object)this.id, (Object)this.cachedEvents.size());
        api.getClient().handle(this.cachedEvents);
        api.getEventCache().playbackCache(EventCache.Type.GUILD, this.id);
    }

    private void ensureMembers() {
        this.expectedMemberCount = this.partialGuild.getInt("member_count");
        this.members = new TLongObjectHashMap<JSONObject>(this.expectedMemberCount);
        this.removedMembers = new TLongHashSet();
        JSONArray memberArray = this.partialGuild.getJSONArray("members");
        if (memberArray.length() < this.expectedMemberCount && !this.requestedChunk) {
            this.updateStatus(GuildSetupController.Status.CHUNKING);
            this.getController().addGuildForChunking(this.id, this.join);
            this.requestedChunk = true;
        } else if (this.handleMemberChunk(memberArray) && !this.requestedChunk) {
            GuildSetupController.log.trace("Received suspicious members with a guild payload. Attempting to chunk. member_count: {} members: {} actual_members: {} guild_id: {}", new Object[]{this.expectedMemberCount, memberArray.length(), this.members.size(), this.id});
            this.members.clear();
            this.updateStatus(GuildSetupController.Status.CHUNKING);
            this.getController().addGuildForChunking(this.id, this.join);
            this.requestedChunk = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAudioManagerReference(GuildImpl guild) {
        TLongObjectMap<AudioManager> audioManagerMap;
        JDAImpl api = this.getController().getJDA();
        TLongObjectMap<AudioManager> tLongObjectMap = audioManagerMap = api.getAudioManagerMap();
        synchronized (tLongObjectMap) {
            AudioManagerImpl mng = (AudioManagerImpl)audioManagerMap.get(this.id);
            if (mng == null) {
                return;
            }
            ConnectionListener listener = mng.getConnectionListener();
            AudioManagerImpl newMng = new AudioManagerImpl(guild);
            newMng.setSelfMuted(mng.isSelfMuted());
            newMng.setSelfDeafened(mng.isSelfDeafened());
            newMng.setQueueTimeout(mng.getConnectTimeout());
            newMng.setSendingHandler(mng.getSendingHandler());
            newMng.setReceivingHandler(mng.getReceiveHandler());
            newMng.setConnectionListener(listener);
            newMng.setAutoReconnect(mng.isAutoReconnect());
            if (mng.isConnected() || mng.isAttemptingToConnect()) {
                long channelId = mng.isConnected() ? mng.getConnectedChannel().getIdLong() : mng.getQueuedAudioConnection().getIdLong();
                VoiceChannel channel = api.getVoiceChannelById(channelId);
                if (channel != null) {
                    if (mng.isConnected()) {
                        mng.closeAudioConnection(ConnectionStatus.ERROR_CANNOT_RESUME);
                    }
                    newMng.setQueuedAudioConnection(channel);
                } else {
                    api.getClient().removeAudioConnection(this.id);
                    if (listener != null) {
                        listener.onStatusChange(ConnectionStatus.DISCONNECTED_CHANNEL_DELETED);
                    }
                }
            }
            audioManagerMap.put(this.id, newMng);
        }
    }
}

