/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import magibridge.org.json.JSONArray;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateAfkChannelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateAfkTimeoutEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateExplicitContentLevelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateFeaturesEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateIconEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateMFALevelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateNameEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateNotificationLevelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateOwnerEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateRegionEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateSplashEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateSystemChannelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateVerificationLevelEvent;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.WebSocketClient;

public class GuildUpdateHandler
extends SocketHandler {
    public GuildUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        Set<String> features;
        TextChannel systemChannel;
        long id = content.getLong("id");
        if (this.getJDA().getGuildSetupController().isLocked(id)) {
            return id;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildMap().get(id);
        long ownerId = content.getLong("owner_id");
        String name = content.getString("name");
        String iconId = content.optString("icon", null);
        String splashId = content.optString("splash", null);
        String region = content.getString("region");
        Guild.VerificationLevel verificationLevel = Guild.VerificationLevel.fromKey(content.getInt("verification_level"));
        Guild.NotificationLevel notificationLevel = Guild.NotificationLevel.fromKey(content.getInt("default_message_notifications"));
        Guild.MFALevel mfaLevel = Guild.MFALevel.fromKey(content.getInt("mfa_level"));
        Guild.ExplicitContentLevel explicitContentLevel = Guild.ExplicitContentLevel.fromKey(content.getInt("explicit_content_filter"));
        Guild.Timeout afkTimeout = Guild.Timeout.fromKey(content.getInt("afk_timeout"));
        VoiceChannel afkChannel = content.isNull("afk_channel_id") ? null : guild.getVoiceChannelsMap().get(content.getLong("afk_channel_id"));
        TextChannel textChannel = systemChannel = content.isNull("system_channel_id") ? null : guild.getTextChannelsMap().get(content.getLong("system_channel_id"));
        if (!content.isNull("features")) {
            JSONArray featureArr = content.getJSONArray("features");
            features = StreamSupport.stream(featureArr.spliterator(), false).map(String::valueOf).collect(Collectors.toSet());
        } else {
            features = Collections.emptySet();
        }
        if (ownerId != guild.getOwnerIdLong()) {
            Member oldOwner = guild.getOwner();
            Member newOwner = guild.getMembersMap().get(ownerId);
            if (newOwner == null) {
                WebSocketClient.LOG.warn("Received {} with owner not in cache. UserId: {} GuildId: {}", new Object[]{this.allContent.get("t"), ownerId, id});
            }
            guild.setOwner(newOwner);
            guild.setOwnerId(ownerId);
            this.getJDA().getEventManager().handle(new GuildUpdateOwnerEvent(this.getJDA(), this.responseNumber, guild, oldOwner));
        }
        if (!Objects.equals(name, guild.getName())) {
            String oldName = guild.getName();
            guild.setName(name);
            this.getJDA().getEventManager().handle(new GuildUpdateNameEvent(this.getJDA(), this.responseNumber, guild, oldName));
        }
        if (!Objects.equals(iconId, guild.getIconId())) {
            String oldIconId = guild.getIconId();
            guild.setIconId(iconId);
            this.getJDA().getEventManager().handle(new GuildUpdateIconEvent(this.getJDA(), this.responseNumber, guild, oldIconId));
        }
        if (!features.equals(guild.getFeatures())) {
            Set<String> oldFeatures = guild.getFeatures();
            guild.setFeatures(features);
            this.getJDA().getEventManager().handle(new GuildUpdateFeaturesEvent(this.getJDA(), this.responseNumber, guild, oldFeatures));
        }
        if (!Objects.equals(splashId, guild.getSplashId())) {
            String oldSplashId = guild.getSplashId();
            guild.setSplashId(splashId);
            this.getJDA().getEventManager().handle(new GuildUpdateSplashEvent(this.getJDA(), this.responseNumber, guild, oldSplashId));
        }
        if (!Objects.equals(region, guild.getRegionRaw())) {
            String oldRegion = guild.getRegionRaw();
            guild.setRegion(region);
            this.getJDA().getEventManager().handle(new GuildUpdateRegionEvent(this.getJDA(), this.responseNumber, guild, oldRegion));
        }
        if (!Objects.equals((Object)verificationLevel, (Object)guild.getVerificationLevel())) {
            Guild.VerificationLevel oldVerificationLevel = guild.getVerificationLevel();
            guild.setVerificationLevel(verificationLevel);
            this.getJDA().getEventManager().handle(new GuildUpdateVerificationLevelEvent(this.getJDA(), this.responseNumber, guild, oldVerificationLevel));
        }
        if (!Objects.equals((Object)notificationLevel, (Object)guild.getDefaultNotificationLevel())) {
            Guild.NotificationLevel oldNotificationLevel = guild.getDefaultNotificationLevel();
            guild.setDefaultNotificationLevel(notificationLevel);
            this.getJDA().getEventManager().handle(new GuildUpdateNotificationLevelEvent(this.getJDA(), this.responseNumber, guild, oldNotificationLevel));
        }
        if (!Objects.equals((Object)mfaLevel, (Object)guild.getRequiredMFALevel())) {
            Guild.MFALevel oldMfaLevel = guild.getRequiredMFALevel();
            guild.setRequiredMFALevel(mfaLevel);
            this.getJDA().getEventManager().handle(new GuildUpdateMFALevelEvent(this.getJDA(), this.responseNumber, guild, oldMfaLevel));
        }
        if (!Objects.equals((Object)explicitContentLevel, (Object)guild.getExplicitContentLevel())) {
            Guild.ExplicitContentLevel oldExplicitContentLevel = guild.getExplicitContentLevel();
            guild.setExplicitContentLevel(explicitContentLevel);
            this.getJDA().getEventManager().handle(new GuildUpdateExplicitContentLevelEvent(this.getJDA(), this.responseNumber, guild, oldExplicitContentLevel));
        }
        if (!Objects.equals((Object)afkTimeout, (Object)guild.getAfkTimeout())) {
            Guild.Timeout oldAfkTimeout = guild.getAfkTimeout();
            guild.setAfkTimeout(afkTimeout);
            this.getJDA().getEventManager().handle(new GuildUpdateAfkTimeoutEvent(this.getJDA(), this.responseNumber, guild, oldAfkTimeout));
        }
        if (!Objects.equals(afkChannel, guild.getAfkChannel())) {
            VoiceChannel oldAfkChannel = guild.getAfkChannel();
            guild.setAfkChannel(afkChannel);
            this.getJDA().getEventManager().handle(new GuildUpdateAfkChannelEvent(this.getJDA(), this.responseNumber, guild, oldAfkChannel));
        }
        if (!Objects.equals(systemChannel, guild.getSystemChannel())) {
            TextChannel oldSystemChannel = guild.getSystemChannel();
            guild.setSystemChannel(systemChannel);
            this.getJDA().getEventManager().handle(new GuildUpdateSystemChannelEvent(this.getJDA(), this.responseNumber, guild, oldSystemChannel));
        }
        return null;
    }
}

