/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import magibridge.org.json.JSONObject;
import net.dv8tion.jda.client.events.message.group.react.GroupMessageReactionAddEvent;
import net.dv8tion.jda.client.events.message.group.react.GroupMessageReactionRemoveEvent;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.guild.react.GuildMessageReactionAddEvent;
import net.dv8tion.jda.core.events.message.guild.react.GuildMessageReactionRemoveEvent;
import net.dv8tion.jda.core.events.message.priv.react.PrivateMessageReactionAddEvent;
import net.dv8tion.jda.core.events.message.priv.react.PrivateMessageReactionRemoveEvent;
import net.dv8tion.jda.core.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.core.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.hooks.IEventManager;
import net.dv8tion.jda.core.requests.WebSocketClient;
import net.dv8tion.jda.core.utils.JDALogger;

public class MessageReactionHandler
extends SocketHandler {
    private final boolean add;

    public MessageReactionHandler(JDAImpl api, boolean add) {
        super(api);
        this.add = add;
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        MessageReaction.ReactionEmote rEmote;
        if (!content.isNull("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
                return guildId;
            }
        }
        JSONObject emoji = content.getJSONObject("emoji");
        long userId = content.getLong("user_id");
        long messageId = content.getLong("message_id");
        long channelId = content.getLong("channel_id");
        Long emojiId = emoji.isNull("id") ? null : Long.valueOf(emoji.getLong("id"));
        String emojiName = emoji.optString("name", null);
        boolean emojiAnimated = emoji.optBoolean("animated");
        if (emojiId == null && emojiName == null) {
            WebSocketClient.LOG.debug("Received a reaction {} with no name nor id. json: {}", JDALogger.getLazyString(() -> this.add ? "add" : "remove"), (Object)content);
            return null;
        }
        User user = this.getJDA().getUserById(userId);
        if (user == null) {
            user = this.getJDA().getFakeUserMap().get(userId);
        }
        if (user == null) {
            if (!this.add) {
                return null;
            }
            this.getJDA().getEventCache().cache(EventCache.Type.USER, userId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a reaction for a user that JDA does not currently have cached. UserID: {} ChannelId: {} MessageId: {}", new Object[]{userId, channelId, messageId});
            return null;
        }
        MessageChannel channel = this.getJDA().getTextChannelById(channelId);
        if (channel == null) {
            channel = this.getJDA().getPrivateChannelById(channelId);
        }
        if (channel == null) {
            channel = this.getJDA().getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null && this.getJDA().getAccountType() == AccountType.CLIENT) {
            channel = this.getJDA().asClient().getGroupById(channelId);
        }
        if (channel == null) {
            this.getJDA().getEventCache().cache(EventCache.Type.CHANNEL, channelId, this.responseNumber, this.allContent, this::handle);
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached");
            return null;
        }
        if (emojiId != null) {
            Emote emote = this.getJDA().getEmoteById(emojiId);
            if (emote == null) {
                if (emojiName != null) {
                    emote = new EmoteImpl((long)emojiId, this.getJDA()).setAnimated(emojiAnimated).setName(emojiName);
                } else {
                    WebSocketClient.LOG.debug("Received a reaction {} with a null name. json: {}", JDALogger.getLazyString(() -> this.add ? "add" : "remove"), (Object)content);
                    return null;
                }
            }
            rEmote = new MessageReaction.ReactionEmote(emote);
        } else {
            rEmote = new MessageReaction.ReactionEmote(emojiName, null, this.getJDA());
        }
        MessageReaction reaction = new MessageReaction(channel, rEmote, messageId, user.equals(this.getJDA().getSelfUser()), -1);
        if (this.add) {
            this.onAdd(reaction, user);
        } else {
            this.onRemove(reaction, user);
        }
        return null;
    }

    private void onAdd(MessageReaction reaction, User user) {
        IEventManager manager = this.getJDA().getEventManager();
        switch (reaction.getChannelType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionAddEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case GROUP: {
                manager.handle(new GroupMessageReactionAddEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case PRIVATE: {
                manager.handle(new PrivateMessageReactionAddEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
            }
        }
        manager.handle(new MessageReactionAddEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
    }

    private void onRemove(MessageReaction reaction, User user) {
        IEventManager manager = this.getJDA().getEventManager();
        switch (reaction.getChannelType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionRemoveEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case GROUP: {
                manager.handle(new GroupMessageReactionRemoveEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
                break;
            }
            case PRIVATE: {
                manager.handle(new PrivateMessageReactionRemoveEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
            }
        }
        manager.handle(new MessageReactionRemoveEvent((JDA)this.getJDA(), this.responseNumber, user, reaction));
    }
}

