/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.HierarchyException;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.impl.ManagerBase;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.PermissionUtil;
import net.dv8tion.jda.core.utils.cache.UpstreamReference;
import okhttp3.RequestBody;

public class RoleManager
extends ManagerBase {
    public static final long NAME = 1L;
    public static final long COLOR = 2L;
    public static final long PERMISSION = 4L;
    public static final long HOIST = 8L;
    public static final long MENTIONABLE = 16L;
    protected final UpstreamReference<Role> role;
    protected String name;
    protected int color;
    protected long permissions;
    protected boolean hoist;
    protected boolean mentionable;

    public RoleManager(Role role) {
        super(role.getJDA(), Route.Roles.MODIFY_ROLE.compile(role.getGuild().getId(), role.getId()));
        this.role = new UpstreamReference<Role>(role);
        if (RoleManager.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    public Guild getGuild() {
        return this.getRole().getGuild();
    }

    public Role getRole() {
        return this.role.get();
    }

    @Override
    @CheckReturnValue
    public RoleManager reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        if ((fields & 2L) == 2L) {
            this.color = 0x1FFFFFFF;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManager reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public RoleManager reset() {
        super.reset();
        this.name = null;
        this.color = 0x1FFFFFFF;
        return this;
    }

    @CheckReturnValue
    public RoleManager setName(String name) {
        Checks.notBlank(name, "Name");
        Checks.check(name.length() <= 32, "Name must be within 32 characters in length");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @CheckReturnValue
    public RoleManager setPermissions(long perms) {
        List<Permission> permissionList;
        long selfPermissions = PermissionUtil.getEffectivePermission(this.getGuild().getSelfMember());
        this.setupPermissions();
        long missingPerms = perms;
        missingPerms &= selfPermissions ^ 0xFFFFFFFFFFFFFFFFL;
        if ((missingPerms &= this.permissions ^ 0xFFFFFFFFFFFFFFFFL) != 0L && RoleManager.isPermissionChecksEnabled() && !(permissionList = Permission.getPermissions(missingPerms)).isEmpty()) {
            throw new InsufficientPermissionException(permissionList.get(0));
        }
        this.permissions = perms;
        this.set |= 4L;
        return this;
    }

    @CheckReturnValue
    public RoleManager setPermissions(Permission ... permissions) {
        Checks.notNull(permissions, "Permissions");
        return this.setPermissions(Arrays.asList(permissions));
    }

    @CheckReturnValue
    public RoleManager setPermissions(Collection<Permission> permissions) {
        Checks.noneNull(permissions, "Permissions");
        return this.setPermissions(Permission.getRaw(permissions));
    }

    @CheckReturnValue
    public RoleManager setColor(Color color) {
        this.color = color == null ? 0x1FFFFFFF : color.getRGB();
        this.set |= 2L;
        return this;
    }

    @CheckReturnValue
    public RoleManager setColor(int rgb) {
        this.color = rgb;
        this.set |= 2L;
        return this;
    }

    @CheckReturnValue
    public RoleManager setHoisted(boolean hoisted) {
        this.hoist = hoisted;
        this.set |= 8L;
        return this;
    }

    @CheckReturnValue
    public RoleManager setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        this.set |= 0x10L;
        return this;
    }

    @CheckReturnValue
    public RoleManager givePermissions(Permission ... perms) {
        Checks.notNull(perms, "Permissions");
        return this.givePermissions(Arrays.asList(perms));
    }

    @CheckReturnValue
    public RoleManager givePermissions(Collection<Permission> perms) {
        Checks.noneNull(perms, "Permissions");
        this.setupPermissions();
        return this.setPermissions(this.permissions | Permission.getRaw(perms));
    }

    @CheckReturnValue
    public RoleManager revokePermissions(Permission ... perms) {
        Checks.notNull(perms, "Permissions");
        return this.revokePermissions(Arrays.asList(perms));
    }

    @CheckReturnValue
    public RoleManager revokePermissions(Collection<Permission> perms) {
        Checks.noneNull(perms, "Permissions");
        this.setupPermissions();
        return this.setPermissions(this.permissions & (Permission.getRaw(perms) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject().put("name", this.getRole().getName());
        if (this.shouldUpdate(1L)) {
            object.put("name", this.name);
        }
        if (this.shouldUpdate(4L)) {
            object.put("permissions", this.permissions);
        }
        if (this.shouldUpdate(8L)) {
            object.put("hoist", this.hoist);
        }
        if (this.shouldUpdate(16L)) {
            object.put("mentionable", this.mentionable);
        }
        if (this.shouldUpdate(2L)) {
            object.put("color", this.color == 0x1FFFFFFF ? 0 : this.color & 0xFFFFFF);
        }
        this.reset();
        return this.getRequestBody(object);
    }

    @Override
    protected boolean checkPermissions() {
        Member selfMember = this.getGuild().getSelfMember();
        if (!selfMember.hasPermission(Permission.MANAGE_ROLES)) {
            throw new InsufficientPermissionException(Permission.MANAGE_ROLES);
        }
        if (!selfMember.canInteract(this.getRole())) {
            throw new HierarchyException("Cannot modify a role that is higher or equal in hierarchy");
        }
        return super.checkPermissions();
    }

    private void setupPermissions() {
        if (!this.shouldUpdate(4L)) {
            this.permissions = this.getRole().getPermissionsRaw();
        }
    }
}

