/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers.impl;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.Checks;

public abstract class ManagerBase
extends AuditableRestAction<Void> {
    private static boolean enablePermissionChecks = true;
    protected long set = 0L;

    public static void setPermissionChecksEnabled(boolean enable) {
        enablePermissionChecks = enable;
    }

    public static boolean isPermissionChecksEnabled() {
        return enablePermissionChecks;
    }

    protected ManagerBase(JDA api, Route.CompiledRoute route) {
        super(api, route);
    }

    public ManagerBase reset(long fields) {
        this.set &= fields ^ 0xFFFFFFFFFFFFFFFFL;
        return this;
    }

    public ManagerBase reset(long ... fields) {
        Checks.notNull(fields, "Fields");
        if (fields.length == 0) {
            return this;
        }
        if (fields.length == 1) {
            return this.reset(fields[0]);
        }
        long sum = fields[0];
        for (int i = 1; i < fields.length; ++i) {
            sum |= fields[i];
        }
        return this.reset(sum);
    }

    protected ManagerBase reset() {
        this.set = 0L;
        return this;
    }

    @Override
    public void queue(Consumer<? super Void> success, Consumer<? super Throwable> failure) {
        if (this.shouldUpdate()) {
            super.queue(success, failure);
        } else if (success != null) {
            success.accept(null);
        } else if (DEFAULT_SUCCESS != null) {
            DEFAULT_SUCCESS.accept(null);
        }
    }

    @Override
    public Void complete(boolean shouldQueue) throws RateLimitedException {
        if (this.shouldUpdate()) {
            return (Void)super.complete(shouldQueue);
        }
        return null;
    }

    @Override
    protected void handleResponse(Response response, Request<Void> request) {
        if (response.isOk()) {
            request.onSuccess(null);
        } else {
            request.onFailure(response);
        }
    }

    @Override
    protected BooleanSupplier finalizeChecks() {
        return enablePermissionChecks ? this::checkPermissions : super.finalizeChecks();
    }

    protected Object opt(Object it) {
        return it == null ? JSONObject.NULL : it;
    }

    protected boolean shouldUpdate() {
        return this.set != 0L;
    }

    protected boolean shouldUpdate(long bit) {
        return (this.set & bit) == bit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E> void withLock(E object, Consumer<? super E> consumer) {
        E e = object;
        synchronized (e) {
            consumer.accept(object);
        }
    }

    protected boolean checkPermissions() {
        return true;
    }
}

