/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import magibridge.org.apache.commons.collections4.map.CaseInsensitiveMap;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.audit.ThreadLocalReason;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.RequestFuture;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.RestFuture;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.MiscUtil;
import okhttp3.RequestBody;

public abstract class AuditableRestAction<T>
extends RestAction<T> {
    protected String reason = null;

    public AuditableRestAction(JDA api, Route.CompiledRoute route) {
        super(api, route);
    }

    public AuditableRestAction(JDA api, Route.CompiledRoute route, RequestBody data) {
        super(api, route, data);
    }

    public AuditableRestAction(JDA api, Route.CompiledRoute route, JSONObject data) {
        super(api, route, data);
    }

    @Override
    public AuditableRestAction<T> setCheck(BooleanSupplier checks) {
        return (AuditableRestAction)super.setCheck(checks);
    }

    @CheckReturnValue
    public AuditableRestAction<T> reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    protected CaseInsensitiveMap<String, String> finalizeHeaders() {
        CaseInsensitiveMap<String, String> headers = super.finalizeHeaders();
        if (this.reason == null || this.reason.isEmpty()) {
            String localReason = ThreadLocalReason.getCurrent();
            if (localReason == null || localReason.isEmpty()) {
                return headers;
            }
            return this.generateHeaders(headers, localReason);
        }
        return this.generateHeaders(headers, this.reason);
    }

    @Nonnull
    private CaseInsensitiveMap<String, String> generateHeaders(CaseInsensitiveMap<String, String> headers, String reason) {
        if (headers == null) {
            headers = new CaseInsensitiveMap();
        }
        headers.put("X-Audit-Log-Reason", this.uriEncode(reason));
        return headers;
    }

    private String uriEncode(String input) {
        String formEncode = MiscUtil.encodeUTF8(input);
        return formEncode.replace('+', ' ');
    }

    public static class EmptyRestAction<T>
    extends AuditableRestAction<T> {
        protected final T content;

        public EmptyRestAction(JDA api) {
            this(api, null);
        }

        public EmptyRestAction(JDA api, T content) {
            super(api, null);
            this.content = content;
        }

        @Override
        public void queue(Consumer<? super T> success, Consumer<? super Throwable> failure) {
            if (success != null) {
                success.accept(this.content);
            }
        }

        @Override
        public RequestFuture<T> submit(boolean shouldQueue) {
            return new RestFuture<T>(this.content);
        }

        @Override
        protected void handleResponse(Response response, Request<T> request) {
        }
    }
}

