/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.Helpers;
import okhttp3.RequestBody;

public class MemberAction
extends RestAction<Void> {
    private final String accessToken;
    private final String userId;
    private final Guild guild;
    private String nick;
    private Set<Role> roles;
    private boolean mute;
    private boolean deaf;

    public MemberAction(JDA api, Guild guild, String userId, String accessToken) {
        super(api, Route.Guilds.ADD_MEMBER.compile(guild.getId(), userId));
        this.accessToken = accessToken;
        this.userId = userId;
        this.guild = guild;
    }

    @Nonnull
    public String getAccessToken() {
        return this.accessToken;
    }

    @Nonnull
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public User getUser() {
        return this.getJDA().getUserById(this.userId);
    }

    @Nonnull
    public Guild getGuild() {
        return this.guild;
    }

    @CheckReturnValue
    public MemberAction setNickname(String nick) {
        if (nick != null) {
            if (Helpers.isBlank(nick)) {
                this.nick = null;
                return this;
            }
            Checks.check(nick.length() <= 32, "Nickname must not be greater than 32 characters in length");
        }
        this.nick = nick;
        return this;
    }

    @CheckReturnValue
    public MemberAction setRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
            return this;
        }
        HashSet<Role> newRoles = new HashSet<Role>(roles.size());
        for (Role role : roles) {
            this.checkAndAdd(newRoles, role);
        }
        this.roles = newRoles;
        return this;
    }

    @CheckReturnValue
    public MemberAction setRoles(Role ... roles) {
        if (roles == null) {
            this.roles = null;
            return this;
        }
        HashSet<Role> newRoles = new HashSet<Role>(roles.length);
        for (Role role : roles) {
            this.checkAndAdd(newRoles, role);
        }
        this.roles = newRoles;
        return this;
    }

    @CheckReturnValue
    public MemberAction setMute(boolean mute) {
        this.mute = mute;
        return this;
    }

    @CheckReturnValue
    public MemberAction setDeafen(boolean deaf) {
        this.deaf = deaf;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject obj = new JSONObject();
        obj.put("access_token", this.accessToken);
        if (this.nick != null) {
            obj.put("nick", this.nick);
        }
        if (this.roles != null && !this.roles.isEmpty()) {
            obj.put("roles", this.roles.stream().map(ISnowflake::getId).collect(Collectors.toList()));
        }
        obj.put("mute", this.mute);
        obj.put("deaf", this.deaf);
        return this.getRequestBody(obj);
    }

    @Override
    protected void handleResponse(Response response, Request<Void> request) {
        if (response.isOk()) {
            request.onSuccess(null);
        } else {
            request.onFailure(response);
        }
    }

    private void checkAndAdd(Set<Role> newRoles, Role role) {
        Checks.notNull(role, "Role");
        Checks.check(role.getGuild().equals(this.getGuild()), "Roles must all be from the same guild");
        newRoles.add(role);
    }
}

