/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.function.BooleanSupplier;
import javax.annotation.CheckReturnValue;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.WebhookImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.RequestBody;

public class WebhookAction
extends AuditableRestAction<Webhook> {
    protected String name;
    protected Icon avatar = null;

    public WebhookAction(JDA api, Route.CompiledRoute route, String name) {
        super(api, route);
        this.name = name;
    }

    @CheckReturnValue
    public WebhookAction setName(String name) {
        Checks.notNull(name, "Webhook name");
        Checks.check(name.length() >= 2 && name.length() <= 100, "The webhook name must be in the range of 2-100!");
        this.name = name;
        return this;
    }

    @Override
    public WebhookAction setCheck(BooleanSupplier checks) {
        return (WebhookAction)super.setCheck(checks);
    }

    @CheckReturnValue
    public WebhookAction setAvatar(Icon icon) {
        this.avatar = icon;
        return this;
    }

    @Override
    public RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        object.put("name", this.name);
        object.put("avatar", this.avatar != null ? this.avatar.getEncoding() : JSONObject.NULL);
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Webhook> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        JSONObject json = response.getObject();
        WebhookImpl webhook = ((JDAImpl)this.api.get()).getEntityBuilder().createWebhook(json);
        request.onSuccess(webhook);
    }
}

