/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.webhook;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import magibridge.org.json.JSONObject;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.requests.RequestFuture;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.webhook.WebhookClient;
import net.dv8tion.jda.webhook.WebhookClientBuilder;
import net.dv8tion.jda.webhook.WebhookMessage;
import net.dv8tion.jda.webhook.WebhookMessageBuilder;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public class WebhookCluster
implements AutoCloseable {
    protected final List<WebhookClient> webhooks;
    protected OkHttpClient.Builder defaultHttpClientBuilder;
    protected OkHttpClient defaultHttpClient;
    protected ScheduledExecutorService defaultPool;
    protected ThreadFactory threadFactory;
    protected boolean isDaemon;

    public WebhookCluster(@Nonnull Collection<? extends WebhookClient> initialClients) {
        this.webhooks = new ArrayList<WebhookClient>(initialClients.size());
        for (WebhookClient webhookClient : initialClients) {
            this.addWebhooks(webhookClient);
        }
    }

    public WebhookCluster(int initialCapacity) {
        this.webhooks = new ArrayList<WebhookClient>(initialCapacity);
    }

    public WebhookCluster() {
        this.webhooks = new ArrayList<WebhookClient>();
    }

    public WebhookCluster setDefaultHttpClientBuilder(@Nullable OkHttpClient.Builder builder) {
        this.defaultHttpClientBuilder = builder;
        return this;
    }

    public WebhookCluster setDefaultHttpClient(@Nullable OkHttpClient defaultHttpClient) {
        this.defaultHttpClient = defaultHttpClient;
        return this;
    }

    public WebhookCluster setDefaultExecutorService(@Nullable ScheduledExecutorService executorService) {
        this.defaultPool = executorService;
        return this;
    }

    public WebhookCluster setDefaultThreadFactory(@Nullable ThreadFactory factory) {
        this.threadFactory = factory;
        return this;
    }

    public WebhookCluster setDefaultDaemon(boolean isDaemon) {
        this.isDaemon = isDaemon;
        return this;
    }

    public WebhookCluster buildWebhooks(Webhook ... webhooks) {
        Checks.notNull(webhooks, "Webhooks");
        for (Webhook webhook : webhooks) {
            Checks.notNull(webhook, "Webhook");
            this.buildWebhook(webhook.getIdLong(), webhook.getToken());
        }
        return this;
    }

    public WebhookCluster buildWebhooks(Collection<Webhook> webhooks) {
        Checks.notNull(webhooks, "Webhooks");
        for (Webhook webhook : webhooks) {
            Checks.notNull(webhook, "Webhook");
            this.buildWebhook(webhook.getIdLong(), webhook.getToken());
        }
        return this;
    }

    public WebhookCluster buildWebhook(long id, String token) {
        this.webhooks.add(this.newBuilder(id, token).build());
        return this;
    }

    public WebhookClientBuilder newBuilder(long id, String token) {
        WebhookClientBuilder builder = new WebhookClientBuilder(id, token);
        builder.setExecutorService(this.defaultPool).setHttpClient(this.defaultHttpClient).setThreadFactory(this.threadFactory).setDaemon(this.isDaemon);
        if (this.defaultHttpClientBuilder != null) {
            builder.setHttpClientBuilder(this.defaultHttpClientBuilder);
        }
        return builder;
    }

    public WebhookClientBuilder newBuilder(Webhook webhook) {
        Checks.notNull(webhook, "Webhook");
        return this.newBuilder(webhook.getIdLong(), webhook.getToken());
    }

    public WebhookCluster addWebhooks(WebhookClient ... clients) {
        Checks.notNull(clients, "Clients");
        for (WebhookClient client : clients) {
            Checks.notNull(client, "Client");
            Checks.check(!client.isShutdown, "One of the provided WebhookClients has been closed already!");
            this.webhooks.add(client);
        }
        return this;
    }

    public WebhookCluster addWebhooks(Collection<WebhookClient> clients) {
        Checks.notNull(clients, "Clients");
        for (WebhookClient client : clients) {
            Checks.notNull(client, "Client");
            Checks.check(!client.isShutdown, "One of the provided WebhookClients has been closed already!");
            this.webhooks.add(client);
        }
        return this;
    }

    public WebhookCluster removeWebhooks(WebhookClient ... clients) {
        Checks.notNull(clients, "Clients");
        this.webhooks.removeAll(Arrays.asList(clients));
        return this;
    }

    public WebhookCluster removeWebhooks(Collection<WebhookClient> clients) {
        Checks.notNull(clients, "Clients");
        this.webhooks.removeAll(clients);
        return this;
    }

    public List<WebhookClient> removeIf(Predicate<WebhookClient> predicate) {
        Checks.notNull(predicate, "Predicate");
        ArrayList<WebhookClient> clients = new ArrayList<WebhookClient>();
        for (WebhookClient client : this.webhooks) {
            if (!predicate.test(client)) continue;
            clients.add(client);
        }
        this.removeWebhooks(clients);
        return clients;
    }

    public List<WebhookClient> closeIf(Predicate<WebhookClient> predicate) {
        Checks.notNull(predicate, "Filter");
        ArrayList<WebhookClient> clients = new ArrayList<WebhookClient>();
        for (WebhookClient client : this.webhooks) {
            if (!predicate.test(client)) continue;
            clients.add(client);
        }
        this.removeWebhooks(clients);
        clients.forEach(WebhookClient::close);
        return clients;
    }

    public List<WebhookClient> getWebhooks() {
        return Collections.unmodifiableList(new ArrayList<WebhookClient>(this.webhooks));
    }

    public List<RequestFuture<?>> multicast(Predicate<WebhookClient> filter, WebhookMessage message) {
        Checks.notNull(filter, "Filter");
        Checks.notNull(message, "Message");
        RequestBody body = message.getBody();
        ArrayList callbacks = new ArrayList();
        for (WebhookClient client : this.webhooks) {
            if (!filter.test(client)) continue;
            callbacks.add(client.execute(body));
        }
        return callbacks;
    }

    public List<RequestFuture<?>> broadcast(WebhookMessage message) {
        Checks.notNull(message, "Message");
        RequestBody body = message.getBody();
        ArrayList callbacks = new ArrayList(this.webhooks.size());
        for (WebhookClient webhook : this.webhooks) {
            callbacks.add(webhook.execute(body));
            if (!message.isFile()) continue;
            body = message.getBody();
        }
        return callbacks;
    }

    public List<RequestFuture<?>> broadcast(Message message) {
        return this.broadcast(WebhookMessage.from(message));
    }

    public List<RequestFuture<?>> broadcast(MessageEmbed[] embeds) {
        return this.broadcast(WebhookMessage.embeds(Arrays.asList(embeds)));
    }

    public List<RequestFuture<?>> broadcast(MessageEmbed first, MessageEmbed ... embeds) {
        return this.broadcast(WebhookMessage.embeds(first, embeds));
    }

    public List<RequestFuture<?>> broadcast(Collection<MessageEmbed> embeds) {
        return this.broadcast(WebhookMessage.embeds(embeds));
    }

    public List<RequestFuture<?>> broadcast(String content) {
        Checks.notBlank(content, "Content");
        Checks.check(content.length() <= 2000, "Content may not exceed 2000 characters!");
        RequestBody body = WebhookClient.newBody(new JSONObject().put("content", content).toString());
        ArrayList callbacks = new ArrayList(this.webhooks.size());
        for (WebhookClient webhook : this.webhooks) {
            callbacks.add(webhook.execute(body));
        }
        return callbacks;
    }

    public List<RequestFuture<?>> broadcast(File file) {
        Checks.notNull(file, "File");
        return this.broadcast(file, file.getName());
    }

    public List<RequestFuture<?>> broadcast(File file, String fileName) {
        Checks.notNull(file, "File");
        Checks.check(file.length() <= 0x800000L, "Provided File exceeds the maximum size of 8MB!");
        return this.broadcast(new WebhookMessageBuilder().addFile(fileName, file).build());
    }

    public List<RequestFuture<?>> broadcast(InputStream data, String fileName) {
        return this.broadcast(new WebhookMessageBuilder().addFile(fileName, data).build());
    }

    public List<RequestFuture<?>> broadcast(byte[] data, String fileName) {
        Checks.notNull(data, "Data");
        Checks.check(data.length < 0x800000, "Provided data exceeds the maximum size of 8MB!");
        return this.broadcast(new WebhookMessageBuilder().addFile(fileName, data).build());
    }

    @Override
    public void close() {
        this.webhooks.forEach(WebhookClient::close);
        this.webhooks.clear();
    }
}

