/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.api.modifier;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.flowpowered.math.vector.Vector3i;
import java.util.Random;
import net.smoofyuniverse.mirage.api.cache.Signature;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifiers;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.util.annotation.CatalogedBy;
import org.spongepowered.api.world.storage.WorldProperties;

@CatalogedBy(value={ChunkModifiers.class})
public abstract class ChunkModifier
implements CatalogType {
    private final Timing timing;
    private final String id;
    private final String name;

    public ChunkModifier(Object plugin, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name");
        }
        PluginContainer container = (PluginContainer)Sponge.getGame().getPluginManager().fromInstance(plugin).orElseThrow(() -> new IllegalArgumentException("Provided object is not a plugin instance"));
        this.timing = Timings.of((Object)container, (String)("Modifier: " + name));
        this.id = container.getId() + ":" + name.toLowerCase();
        this.name = name;
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final Timing getTiming() {
        return this.timing;
    }

    public boolean shouldCache() {
        return true;
    }

    public boolean isCompatible(WorldProperties world) {
        return true;
    }

    public abstract Object loadConfiguration(ConfigurationNode var1, WorldProperties var2, String var3) throws ObjectMappingException;

    public abstract void appendSignature(Signature.Builder var1, Object var2);

    public abstract boolean isReady(ChunkView var1, Object var2);

    public void modify(ChunkView view, Random r, Object config) {
        this.modify(view, view.getBlockMin(), view.getBlockMax(), r, config);
    }

    public abstract void modify(BlockView var1, Vector3i var2, Vector3i var3, Random var4, Object var5);
}

