/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.api.modifier;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifier;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifiers;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.RegistrationPhase;
import org.spongepowered.api.registry.util.DelayedRegistration;

public class ChunkModifierRegistryModule
implements AdditionalCatalogRegistryModule<ChunkModifier> {
    private static final ChunkModifierRegistryModule INSTANCE = new ChunkModifierRegistryModule();
    private static final String DEFAULT_PREFIX = Mirage.get().getContainer().getId() + ":";
    private final Map<String, ChunkModifier> modifiers = new HashMap<String, ChunkModifier>();

    private ChunkModifierRegistryModule() {
    }

    public Optional<ChunkModifier> getById(String id) {
        return Optional.ofNullable(this.modifiers.get((id = id.toLowerCase()).indexOf(58) == -1 ? DEFAULT_PREFIX + id : id));
    }

    public Collection<ChunkModifier> getAll() {
        return ImmutableList.copyOf(this.modifiers.values());
    }

    @DelayedRegistration(value=RegistrationPhase.PRE_INIT)
    public void registerDefaults() {
        this.register(ChunkModifiers.EMPTY);
        this.register(ChunkModifiers.HIDEALL);
        this.register(ChunkModifiers.OBVIOUS);
        this.register(ChunkModifiers.RANDOM);
        this.register(ChunkModifiers.BEDROCK);
        this.register(ChunkModifiers.FAKEGEN);
    }

    private void register(ChunkModifier modifier) {
        this.modifiers.put(modifier.getId(), modifier);
    }

    public void registerAdditionalCatalog(ChunkModifier modifier) {
        if (this.modifiers.containsKey(modifier.getId())) {
            throw new IllegalArgumentException("Cannot register an already registered ChunkModifier: " + modifier.getId());
        }
        this.register(modifier);
    }

    public static ChunkModifierRegistryModule get() {
        return INSTANCE;
    }
}

