/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.api.volume;

import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vectori;
import net.smoofyuniverse.mirage.api.volume.BlockStorage;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.world.extent.MutableBlockVolume;

public interface BlockView
extends MutableBlockVolume {
    public BlockStorage getStorage();

    default public void checkBlockArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.checkBlockPosition(minX, minY, minZ);
        this.checkBlockPosition(maxX, maxY, maxZ);
        if (minX > maxX || minY > maxY || minZ > maxZ) {
            throw new IllegalArgumentException("Invalid area");
        }
    }

    default public void checkBlockPosition(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)this.getBlockMin(), (Vectori)this.getBlockMax());
        }
    }

    public boolean isDynamismEnabled();

    default public void setDynamism(Vector3i pos, int distance) {
        this.setDynamism(pos.getX(), pos.getY(), pos.getZ(), distance);
    }

    public void setDynamism(int var1, int var2, int var3, int var4);

    default public int getDynamism(Vector3i pos) {
        return this.getDynamism(pos.getX(), pos.getY(), pos.getZ());
    }

    public int getDynamism(int var1, int var2, int var3);

    default public boolean isExposed(Vector3i pos) {
        return this.isExposed(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean isExposed(int var1, int var2, int var3);

    default public boolean deobfuscate(Vector3i pos) {
        return this.deobfuscate(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean deobfuscate(int var1, int var2, int var3);

    default public void deobfuscateSurrounding(Vector3i pos, int radius, boolean silentFail) {
        this.deobfuscateSurrounding(pos.getX(), pos.getY(), pos.getZ(), radius, silentFail);
    }

    default public void deobfuscateSurrounding(int x, int y, int z, int radius, boolean silentFail) {
        this.checkBlockPosition(x, y, z);
        if (radius < 0) {
            throw new IllegalArgumentException("Negative radius");
        }
        if (radius == 0) {
            this.deobfuscate(x, y, z);
        } else {
            Vector3i min = this.getBlockMin();
            Vector3i max = this.getBlockMax();
            this.deobfuscateArea(Math.max(x - radius, min.getX()), Math.max(y - radius, min.getY()), Math.max(z - radius, min.getZ()), Math.min(x + radius, max.getX()), Math.min(y + radius, max.getY()), Math.min(z + radius, max.getZ()), silentFail);
        }
    }

    public void deobfuscateArea(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    default public void deobfuscateArea(Vector3i min, Vector3i max, boolean silentFail) {
        this.deobfuscateArea(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ(), silentFail);
    }

    default public void reobfuscateSurrounding(Vector3i pos, int radius, boolean silentFail) {
        this.reobfuscateSurrounding(pos.getX(), pos.getY(), pos.getZ(), radius, silentFail);
    }

    default public void reobfuscateSurrounding(int x, int y, int z, int radius, boolean silentFail) {
        this.checkBlockPosition(x, y, z);
        if (radius < 0) {
            throw new IllegalArgumentException("Negative radius");
        }
        Vector3i min = this.getBlockMin();
        Vector3i max = this.getBlockMax();
        this.reobfuscateArea(Math.max(x - radius, min.getX()), Math.max(y - radius, min.getY()), Math.max(z - radius, min.getZ()), Math.min(x + radius, max.getX()), Math.min(y + radius, max.getY()), Math.min(z + radius, max.getZ()), silentFail);
    }

    public void reobfuscateArea(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    default public void reobfuscateArea(Vector3i min, Vector3i max, boolean silentFail) {
        this.reobfuscateArea(min.getX(), min.getY(), min.getZ(), max.getX(), max.getY(), max.getZ(), silentFail);
    }
}

