/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.config.world;

import com.google.common.reflect.TypeToken;
import net.smoofyuniverse.mirage.config.world.DeobfuscationConfig;
import net.smoofyuniverse.mirage.config.world.PreobfuscationConfig;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;

@ConfigSerializable
public class WorldConfig {
    public static final TypeToken<WorldConfig> TOKEN = TypeToken.of(WorldConfig.class);
    @Setting(value="Enabled", comment="Enable or disable Mirage in this world")
    public boolean enabled = true;
    @Setting(value="Cache", comment="Enable or disable caching fake chunks on disk")
    public boolean cache = true;
    @Setting(value="Dynamism", comment="Enable or disable dynamic obfuscation")
    public boolean dynamism = true;
    @Setting(value="Seed", comment="The seed used by the modifier, shouldn't be modified")
    public long seed = 0L;
    @Setting(value="Deobfuscation")
    public DeobfuscationConfig deobf = new DeobfuscationConfig();
    @Setting(value="Preobfuscation", comment="Temporary obfuscation when modifiers are not ready yet")
    public PreobfuscationConfig preobf = new PreobfuscationConfig();

    public WorldConfig(boolean enabled) {
        this.enabled = enabled;
    }

    public WorldConfig() {
    }

    public Immutable toImmutable() {
        return new Immutable(this.enabled, this.cache, this.dynamism, this.seed, this.deobf.toImmutable(), this.preobf.toImmutable());
    }

    public static class Immutable {
        public final boolean enabled;
        public final boolean cache;
        public final boolean dynamism;
        public final long seed;
        public final DeobfuscationConfig.Immutable deobf;
        public final PreobfuscationConfig.Immutable preobf;

        public Immutable(boolean enabled, boolean cache, boolean dynamism, long seed, DeobfuscationConfig.Immutable deobf, PreobfuscationConfig.Immutable preobf) {
            this.enabled = enabled;
            this.cache = cache;
            this.dynamism = dynamism;
            this.seed = seed;
            this.deobf = deobf;
            this.preobf = preobf;
        }
    }
}

