/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network;

import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BitArray;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.BlockStateContainer;
import net.minecraft.world.chunk.BlockStatePaletteHashMap;
import net.minecraft.world.chunk.BlockStatePaletteLinear;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraft.world.chunk.IBlockStatePaletteResizer;
import net.minecraft.world.chunk.NibbleArray;
import net.smoofyuniverse.mirage.impl.internal.InternalBlockContainer;
import net.smoofyuniverse.mirage.impl.network.cache.BlockContainerSnapshot;
import net.smoofyuniverse.mirage.impl.network.change.ChunkChangeListener;
import net.smoofyuniverse.mirage.impl.network.dynamism.DynamicChunk;
import net.smoofyuniverse.mirage.util.MathUtil;

public class NetworkBlockContainer
implements IBlockStatePaletteResizer {
    private static final ObjectIntIdentityMap<IBlockState> BLOCK_STATE_IDS = Block.field_176229_d;
    private static final IBlockStatePalette REGISTRY_BASED_PALETTE = BlockStateContainer.field_186023_d;
    private static final IBlockState AIR_BLOCK_STATE = BlockStateContainer.field_186020_a;
    private BlockStateContainer container;
    private IBlockStatePalette palette;
    private NibbleArray dynamism;
    private BitArray storage;
    private int bits;
    private int minY = -1;
    private int[] dynCount = new int[16];
    private int blockCount;

    public NetworkBlockContainer(BlockStateContainer container) {
        this.container = container;
        this.dynamism = new NibbleArray();
        this.dynCount[0] = 4096;
    }

    public InternalBlockContainer getInternalBlockContainer() {
        return (InternalBlockContainer)this.container;
    }

    public int getY() {
        return this.minY;
    }

    public void setY(int y) {
        this.minY = y;
    }

    public boolean isEmpty() {
        return this.blockCount == 0;
    }

    public IBlockState get(int index) {
        IBlockState state = this.palette.func_186039_a(this.storage.func_188142_a(index));
        return state == null ? AIR_BLOCK_STATE : state;
    }

    private void _set(int index, IBlockState state) {
        int i = this.palette.func_186041_a(state);
        this.storage.func_188141_a(index, i);
    }

    public void setBits(int bits) {
        if (this.bits != bits) {
            this.bits = bits;
            if (this.bits <= 4) {
                this.bits = 4;
                this.palette = new BlockStatePaletteLinear(this.bits, (IBlockStatePaletteResizer)this);
            } else if (this.bits <= 8) {
                this.palette = new BlockStatePaletteHashMap(this.bits, (IBlockStatePaletteResizer)this);
            } else {
                this.palette = REGISTRY_BASED_PALETTE;
                this.bits = MathHelper.func_151241_e((int)BLOCK_STATE_IDS.func_186804_a());
            }
            this.palette.func_186041_a(AIR_BLOCK_STATE);
            this.storage = new BitArray(this.bits, 4096);
        }
    }

    public void deobfuscate(ChunkChangeListener listener) {
        this.blockCount = 0;
        for (int i = 0; i < 4096; ++i) {
            IBlockState fakeState = this.get(i);
            IBlockState realState = this.container.func_186015_a(i);
            if (realState.func_177230_c() != Blocks.field_150350_a) {
                ++this.blockCount;
            }
            if (fakeState == realState) continue;
            this._set(i, realState);
            if (listener == null) continue;
            listener.addChange(i & 0xF, this.minY + (i >> 8 & 0xF), i >> 4 & 0xF);
        }
    }

    public boolean deobfuscate(ChunkChangeListener listener, int x, int y, int z) {
        IBlockState realState;
        int i = NetworkBlockContainer.index(x, y, z);
        IBlockState fakeState = this.get(i);
        if (fakeState != (realState = this.container.func_186015_a(i))) {
            if (realState.func_177230_c() == Blocks.field_150350_a) {
                --this.blockCount;
            } else if (fakeState.func_177230_c() == Blocks.field_150350_a) {
                ++this.blockCount;
            }
            this.setDynamism(i, 0);
            this._set(i, realState);
            if (listener != null) {
                listener.updateDynamism(x, this.minY + y, z, 0);
                listener.addChange(x, this.minY + y, z);
            }
            return true;
        }
        return false;
    }

    public static int index(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public void setDynamism(int index, int distance) {
        int oldD = this.dynamism.func_177480_a(index);
        if (oldD != distance) {
            this.dynamism.func_177482_a(index, distance);
            int n = oldD;
            this.dynCount[n] = this.dynCount[n] - 1;
            int n2 = distance;
            this.dynCount[n2] = this.dynCount[n2] + 1;
        }
    }

    public void preobfuscate(ChunkChangeListener listener, Set<?> ores, IBlockState ground) {
        boolean notAirGround = ground.func_177230_c() != Blocks.field_150350_a;
        this.blockCount = 0;
        for (int i = 0; i < 4096; ++i) {
            IBlockState state = this.get(i);
            if (ores.contains(state)) {
                if (notAirGround) {
                    ++this.blockCount;
                }
                this._set(i, ground);
                if (listener == null) continue;
                listener.addChange(i & 0xF, this.minY + (i >> 8 & 0xF), i >> 4 & 0xF);
                continue;
            }
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            ++this.blockCount;
        }
    }

    public int getMaxDynamism() {
        for (int i = 10; i >= 0; --i) {
            if (this.dynCount[i] == 0) continue;
            return i;
        }
        return 0;
    }

    public void clearDynamism() {
        this.dynamism = new NibbleArray();
        Arrays.fill(this.dynCount, 0);
        this.dynCount[0] = 4096;
    }

    public void setDynamism(int x, int y, int z, int distance) {
        this.setDynamism(NetworkBlockContainer.index(x, y, z), distance);
    }

    public int getDynamism(int x, int y, int z) {
        return this.getDynamism(NetworkBlockContainer.index(x, y, z));
    }

    public int getDynamism(int index) {
        return this.dynamism.func_177480_a(index);
    }

    public void collectDynamicPositions(DynamicChunk chunk, int cX, int cY, int cZ) {
        if (this.dynCount[0] == 4096) {
            return;
        }
        for (int i = 0; i < 4096; ++i) {
            int z;
            int y;
            int x;
            int d = this.dynamism.func_177480_a(i);
            if (d == 0 || MathUtil.lengthSquared(cX - (x = i & 0xF), cY - (y = i >> 8 & 0xF), cZ - (z = i >> 4 & 0xF)) > MathUtil.squared(d) << 8) continue;
            chunk.add(x, this.minY + y, z);
        }
    }

    public IBlockState get(int x, int y, int z) {
        return this.get(NetworkBlockContainer.index(x, y, z));
    }

    public void set(int index, IBlockState state) {
        IBlockState oldState = this.get(index);
        if (oldState != state) {
            if (oldState.func_177230_c() == Blocks.field_150350_a) {
                ++this.blockCount;
            } else if (state.func_177230_c() == Blocks.field_150350_a) {
                --this.blockCount;
            }
            this._set(index, state);
        }
    }

    public int func_186008_a(int bits, IBlockState state) {
        BitArray oldStorage = this.storage;
        IBlockStatePalette oldPalette = this.palette;
        this.setBits(bits);
        for (int i = 0; i < 4096; ++i) {
            IBlockState block = oldPalette.func_186039_a(oldStorage.func_188142_a(i));
            if (block == null) continue;
            this._set(i, block);
        }
        return this.palette.func_186041_a(state);
    }

    public void write(PacketBuffer buf) {
        buf.writeByte(this.bits);
        this.palette.func_186037_b(buf);
        buf.func_186865_a(this.storage.func_188143_a());
    }

    public void set(int x, int y, int z, IBlockState state) {
        this.set(NetworkBlockContainer.index(x, y, z), state);
    }

    @Nullable
    private NibbleArray getDataForNBT(byte[] blockIds, NibbleArray data) {
        NibbleArray extension = null;
        for (int i = 0; i < 4096; ++i) {
            int id = BLOCK_STATE_IDS.func_148747_b((Object)this.get(i));
            int x = i & 0xF;
            int y = i >> 8 & 0xF;
            int z = i >> 4 & 0xF;
            if ((id >> 12 & 0xF) != 0) {
                if (extension == null) {
                    extension = new NibbleArray();
                }
                extension.func_76581_a(x, y, z, id >> 12 & 0xF);
            }
            blockIds[i] = (byte)(id >> 4 & 0xFF);
            data.func_76581_a(x, y, z, id & 0xF);
        }
        return extension;
    }

    public void save(BlockContainerSnapshot out) {
        byte[] blockIds = new byte[4096];
        NibbleArray data = new NibbleArray();
        NibbleArray extension = this.getDataForNBT(blockIds, data);
        byte[] dynamism = (byte[])this.dynamism.func_177481_a().clone();
        out.setSection(this.minY >> 4);
        out.setBlockIds(blockIds);
        out.setData(data.func_177481_a());
        out.setExtension(extension == null ? null : extension.func_177481_a());
        out.setDynamism(dynamism);
    }

    public void load(BlockContainerSnapshot in) {
        if (in.getSection() != this.minY >> 4) {
            throw new IllegalArgumentException("Section");
        }
        this.setDataFromNBT(in.getBlockIds(), new NibbleArray(in.getData()), in.getExtension() == null ? null : new NibbleArray(in.getExtension()));
        this.dynamism = new NibbleArray((byte[])in.getDynamism().clone());
        this.recalculateDynCount();
    }

    private void setDataFromNBT(byte[] blockIds, NibbleArray data, @Nullable NibbleArray extension) {
        this.blockCount = 0;
        for (int i = 0; i < 4096; ++i) {
            int z;
            int y;
            int x;
            int ext = extension == null ? 0 : extension.func_76582_a(x, y, z);
            int id = ext << 12 | (blockIds[i] & 0xFF) << 4 | data.func_76582_a(x = i & 0xF, y = i >> 8 & 0xF, z = i >> 4 & 0xF);
            IBlockState block = (IBlockState)BLOCK_STATE_IDS.func_148745_a(id);
            if (block.func_177230_c() != Blocks.field_150350_a) {
                ++this.blockCount;
            }
            this._set(i, block);
        }
    }

    public int getSerializedSize() {
        return 1 + this.palette.func_186040_a() + PacketBuffer.func_150790_a((int)this.storage.func_188144_b()) + this.storage.func_188143_a().length * 8;
    }

    private void recalculateDynCount() {
        Arrays.fill(this.dynCount, 0);
        for (int i = 0; i < 4096; ++i) {
            int n = this.dynamism.func_177480_a(i);
            this.dynCount[n] = this.dynCount[n] + 1;
        }
    }
}

