/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3i;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.MirageTimings;
import net.smoofyuniverse.mirage.api.modifier.ConfiguredModifier;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.config.world.PreobfuscationConfig;
import net.smoofyuniverse.mirage.impl.internal.InternalBlockContainer;
import net.smoofyuniverse.mirage.impl.internal.InternalBlockState;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.network.NetworkBlockContainer;
import net.smoofyuniverse.mirage.impl.network.NetworkWorld;
import net.smoofyuniverse.mirage.impl.network.cache.BlockContainerSnapshot;
import net.smoofyuniverse.mirage.impl.network.cache.ChunkSnapshot;
import net.smoofyuniverse.mirage.impl.network.change.ChunkChangeListener;
import net.smoofyuniverse.mirage.impl.network.dynamism.DynamicChunk;
import net.smoofyuniverse.mirage.util.MathUtil;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.extent.BlockVolume;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.gen.ArrayImmutableBlockBuffer;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.extent.ExtentBufferUtil;
import org.spongepowered.common.world.extent.MutableBlockViewDownsize;
import org.spongepowered.common.world.extent.MutableBlockViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBlockVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

public class NetworkChunk
implements ChunkView {
    public static final int maxDynamismDistance = 160;
    public static final int maxDynamismDistance2 = MathUtil.squared(160);
    private final Vector3i position;
    private final Vector3i blockMin;
    private final Vector3i blockMax;
    private final InternalChunk chunk;
    private final NetworkWorld world;
    public final int x;
    public final int z;
    private final boolean dynamismEnabled;
    private final long seed;
    private NetworkBlockContainer[] containers;
    private ChunkView.State state = ChunkView.State.DEOBFUSCATED;
    private ChunkChangeListener listener;
    private Random random = new Random();
    private boolean saved = true;

    public NetworkChunk(InternalChunk chunk, NetworkWorld world) {
        this.chunk = chunk;
        this.world = world;
        this.position = chunk.getPosition();
        this.blockMin = chunk.getBlockMin();
        this.blockMax = chunk.getBlockMax();
        this.dynamismEnabled = world.isDynamismEnabled();
        this.x = this.position.getX();
        this.z = this.position.getZ();
        long wSeed = world.getConfig().seed;
        this.random.setSeed(wSeed);
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.seed = (long)this.x * k + (long)this.z * l ^ wSeed;
    }

    public void setContainers(ExtendedBlockStorage[] storages) {
        NetworkBlockContainer[] containers = new NetworkBlockContainer[storages.length];
        for (int i = 0; i < storages.length; ++i) {
            if (storages[i] == null) continue;
            containers[i] = ((InternalBlockContainer)storages[i].func_186049_g()).getNetworkBlockContainer();
        }
        this.setContainers(containers);
    }

    public void setContainers(NetworkBlockContainer[] containers) {
        if (this.state != ChunkView.State.DEOBFUSCATED) {
            throw new IllegalStateException("Chunk must be deobfuscated");
        }
        if (this.containers != null) {
            for (NetworkBlockContainer c : this.containers) {
                if (c == null) continue;
                c.getInternalBlockContainer().setNetworkChunk(null);
            }
        }
        if (containers != null) {
            for (NetworkBlockContainer c : containers) {
                if (c == null) continue;
                c.getInternalBlockContainer().setNetworkChunk(this);
            }
        }
        this.containers = containers;
    }

    public void setContainer(int index, ExtendedBlockStorage s) {
        this.setContainer(index, ((InternalBlockContainer)s.func_186049_g()).getNetworkBlockContainer());
    }

    public void setContainer(int index, NetworkBlockContainer c) {
        if (this.containers == null) {
            throw new UnsupportedOperationException("Containers not initialized");
        }
        if (this.containers[index] != null) {
            throw new UnsupportedOperationException("Index already initialized");
        }
        if (c == null) {
            throw new IllegalArgumentException();
        }
        c.getInternalBlockContainer().setNetworkChunk(this);
        this.containers[index] = c;
    }

    public boolean needContainer(int index) {
        return this.containers != null && this.containers[index] == null;
    }

    public Optional<ChunkChangeListener> getListener() {
        return Optional.ofNullable(this.listener);
    }

    public void setListener(ChunkChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public ChunkView.State getState() {
        return this.state;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean value) {
        this.saved = value;
    }

    public void saveToCacheLater() {
        if (this.shouldSave()) {
            long date;
            if (this.world.useCache()) {
                ChunkSnapshot chunk = this.save(new ChunkSnapshot());
                this.world.addPendingSave(this.x, this.z, chunk);
                date = chunk.getDate();
            } else {
                date = System.currentTimeMillis();
            }
            this.chunk.setValidCacheDate(date);
            ((Chunk)this.chunk).func_76630_e();
            this.saved = true;
        }
    }

    public boolean shouldSave() {
        return !this.saved && this.state == ChunkView.State.OBFUSCATED;
    }

    public ChunkSnapshot save(ChunkSnapshot out) {
        ArrayList<BlockContainerSnapshot> list = new ArrayList<BlockContainerSnapshot>(this.containers.length);
        for (NetworkBlockContainer container : this.containers) {
            if (container == null) continue;
            BlockContainerSnapshot data = new BlockContainerSnapshot();
            container.save(data);
            list.add(data);
        }
        out.setContainers(list.toArray(new BlockContainerSnapshot[0]));
        out.setDate(System.currentTimeMillis());
        return out;
    }

    public void saveToCacheNow() {
        if (this.shouldSave()) {
            long date;
            if (this.world.useCache()) {
                ChunkSnapshot chunk = this.save(new ChunkSnapshot());
                this.world.removePendingSave(this.x, this.z);
                this.world.saveToCache(this.x, this.z, chunk);
                date = chunk.getDate();
            } else {
                date = System.currentTimeMillis();
            }
            this.chunk.setValidCacheDate(date);
            ((Chunk)this.chunk).func_76630_e();
            this.saved = true;
        }
    }

    public void loadFromCacheNow() {
        ChunkSnapshot chunk;
        if (this.world.useCache() && (chunk = this.world.readFromCache(this.x, this.z)) != null && chunk.getDate() == this.chunk.getValidCacheDate()) {
            this.world.removePendingSave(this.x, this.z);
            this.load(chunk);
            this.state = ChunkView.State.OBFUSCATED;
            this.saved = true;
        }
    }

    public void load(ChunkSnapshot in) {
        for (BlockContainerSnapshot data : in.getContainers()) {
            NetworkBlockContainer container = this.containers[data.getSection()];
            if (container == null) continue;
            container.load(data);
        }
    }

    @Override
    public InternalChunk getStorage() {
        return this.chunk;
    }

    @Override
    public boolean isDynamismEnabled() {
        return this.dynamismEnabled;
    }

    @Override
    public void obfuscate() {
        Timing timing;
        if (this.state == ChunkView.State.OBFUSCATED) {
            return;
        }
        MirageTimings.OBFUSCATION.startTiming();
        boolean ready = true;
        for (ConfiguredModifier mod : this.world.getModifiers()) {
            timing = mod.modifier.getTiming();
            timing.startTiming();
            if (!mod.modifier.isReady(this, mod.config)) {
                ready = false;
                timing.stopTiming();
                break;
            }
            timing.stopTiming();
        }
        if (this.state == ChunkView.State.PREOBFUSCATED) {
            if (!ready) {
                MirageTimings.OBFUSCATION.stopTiming();
                return;
            }
            if (this.world.getConfig().preobf.enabled) {
                this.deobfuscate();
            }
        }
        if (ready) {
            this.random.setSeed(this.seed);
            for (ConfiguredModifier mod : this.world.getModifiers()) {
                timing = mod.modifier.getTiming();
                timing.startTiming();
                try {
                    mod.modifier.modify(this, this.random, mod.config);
                }
                catch (Exception ex) {
                    Mirage.LOGGER.error("Modifier " + mod.modifier.getId() + " has thrown an exception while modifying a network chunk", (Throwable)ex);
                }
                timing.stopTiming();
            }
            this.state = ChunkView.State.OBFUSCATED;
        } else {
            this.preobfuscate();
        }
        MirageTimings.OBFUSCATION.stopTiming();
    }

    @Override
    public void deobfuscate() {
        if (this.state == ChunkView.State.DEOBFUSCATED) {
            return;
        }
        MirageTimings.DEOBFUSCATION.startTiming();
        for (NetworkBlockContainer c : this.containers) {
            if (c == null) continue;
            c.clearDynamism();
            c.deobfuscate(this.listener);
        }
        if (this.listener != null) {
            this.listener.clearDynamism();
        }
        this.state = ChunkView.State.DEOBFUSCATED;
        MirageTimings.DEOBFUSCATION.stopTiming();
    }

    @Override
    public void reobfuscate() {
        if (this.state != ChunkView.State.OBFUSCATED) {
            throw new IllegalStateException("Chunk must be fully obfuscated");
        }
        this.deobfuscate();
        this.obfuscate();
    }

    protected void preobfuscate() {
        if (this.state == ChunkView.State.OBFUSCATED) {
            throw new IllegalStateException("Chunk is already obfuscated");
        }
        if (this.state == ChunkView.State.PREOBFUSCATED) {
            return;
        }
        PreobfuscationConfig.Immutable cfg = this.world.getConfig().preobf;
        if (cfg.enabled) {
            MirageTimings.PREOBFUSCATION.startTiming();
            for (NetworkBlockContainer c : this.containers) {
                if (c == null) continue;
                c.clearDynamism();
                c.preobfuscate(this.listener, cfg.blocks, (IBlockState)cfg.replacement);
            }
            if (this.listener != null) {
                this.listener.clearDynamism();
            }
            MirageTimings.PREOBFUSCATION.stopTiming();
        }
        this.state = ChunkView.State.PREOBFUSCATED;
    }

    public void collectDynamicPositions(DynamicChunk chunk) {
        if (!this.dynamismEnabled) {
            return;
        }
        Vector3i center = chunk.getCenter();
        if (center == null) {
            return;
        }
        int relX = center.getX() - (this.x << 4);
        int relZ = center.getZ() - (this.z << 4);
        int minXZDistance2 = MathUtil.lengthSquared(MathUtil.clamp(relX, 0, 15) - relX, MathUtil.clamp(relZ, 0, 15) - relZ);
        if (minXZDistance2 + MathUtil.squared(MathUtil.clamp(center.getY(), 0, 255) - center.getY()) > maxDynamismDistance2) {
            return;
        }
        for (NetworkBlockContainer c : this.containers) {
            int relY;
            int d2;
            if (c == null || (d2 = minXZDistance2 + MathUtil.squared(MathUtil.clamp(relY = center.getY() - c.getY(), 0, 15) - relY)) > maxDynamismDistance2 || d2 > MathUtil.squared(c.getMaxDynamism()) << 8) continue;
            c.collectDynamicPositions(chunk, relX, relY, relZ);
        }
    }

    @Override
    public NetworkWorld getWorld() {
        return this.world;
    }

    @Override
    public Vector3i getPosition() {
        return this.position;
    }

    @Override
    public void setDynamism(int x, int y, int z, int distance) {
        this.checkBlockPosition(x, y, z);
        if (!this.dynamismEnabled) {
            return;
        }
        NetworkBlockContainer container = this.containers[y >> 4];
        if (container == null) {
            this.chunk.bindContainer(y >> 4);
            container = this.containers[y >> 4];
        }
        distance = MathUtil.clamp(distance, 0, 10);
        container.setDynamism(x & 0xF, y & 0xF, z & 0xF, distance);
        if (this.listener != null) {
            this.listener.updateDynamism(x & 0xF, y, z & 0xF, distance);
        }
        this.saved = false;
    }

    @Override
    public int getDynamism(int x, int y, int z) {
        this.checkBlockPosition(x, y, z);
        if (!this.dynamismEnabled) {
            return 0;
        }
        NetworkBlockContainer c = this.containers[y >> 4];
        return c == null ? 0 : c.getDynamism(x & 0xF, y & 0xF, z & 0xF);
    }

    @Override
    public boolean isExposed(int x, int y, int z) {
        NetworkChunk c;
        this.checkBlockPosition(x, y, z);
        if (y == 255 || !this.isOpaque(x &= 0xF, y + 1, z &= 0xF)) {
            return true;
        }
        if (y == 0 || !this.isOpaque(x, y - 1, z)) {
            return true;
        }
        if (x == 15 ? (c = this.world.getChunk(this.x + 1, this.z)) == null || !c.isOpaque(0, y, z) : !this.isOpaque(x + 1, y, z)) {
            return true;
        }
        if (x == 0 ? (c = this.world.getChunk(this.x - 1, this.z)) == null || !c.isOpaque(15, y, z) : !this.isOpaque(x - 1, y, z)) {
            return true;
        }
        if (z == 15 ? (c = this.world.getChunk(this.x, this.z + 1)) == null || !c.isOpaque(x, y, 0) : !this.isOpaque(x, y, z + 1)) {
            return true;
        }
        return z == 0 ? (c = this.world.getChunk(this.x, this.z - 1)) == null || !c.isOpaque(x, y, 15) : !this.isOpaque(x, y, z - 1);
    }

    private boolean isOpaque(int x, int y, int z) {
        NetworkBlockContainer c = this.containers[y >> 4];
        return c != null && ((InternalBlockState)c.get(x, y & 0xF, z)).isOpaque();
    }

    @Override
    public boolean deobfuscate(int x, int y, int z) {
        this.checkBlockPosition(x, y, z);
        if (this.state == ChunkView.State.DEOBFUSCATED) {
            return false;
        }
        NetworkBlockContainer container = this.containers[y >> 4];
        if (container != null && container.deobfuscate(this.listener, x & 0xF, y & 0xF, z & 0xF)) {
            this.saved = false;
            return true;
        }
        return false;
    }

    @Override
    public void deobfuscateArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean silentFail) {
        this.checkBlockArea(minX, minY, minZ, maxX, maxY, maxZ);
        if (this.state != ChunkView.State.DEOBFUSCATED) {
            this.deobfuscate(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    public Vector3i getBlockMin() {
        return this.blockMin;
    }

    public Vector3i getBlockMax() {
        return this.blockMax;
    }

    public Vector3i getBlockSize() {
        return SpongeChunkLayout.CHUNK_SIZE;
    }

    public boolean containsBlock(int x, int y, int z) {
        return VecHelper.inBounds((int)x, (int)y, (int)z, (Vector3i)this.blockMin, (Vector3i)this.blockMax);
    }

    public BlockType getBlockType(int x, int y, int z) {
        return this.getBlock(x, y, z).getType();
    }

    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return new UnmodifiableBlockVolumeWrapper((MutableBlockVolume)this);
    }

    public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ArrayMutableBlockBuffer(GlobalPalette.getBlockPalette(), this.getBlockMin(), this.getBlockSize(), ExtentBufferUtil.copyToArray((BlockVolume)this, (Vector3i)this.getBlockMin(), (Vector3i)this.getBlockMax(), (Vector3i)this.getBlockSize()));
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    public ImmutableBlockVolume getImmutableBlockCopy() {
        return ArrayImmutableBlockBuffer.newWithoutArrayClone((Palette)GlobalPalette.getBlockPalette(), (Vector3i)this.getBlockMin(), (Vector3i)this.getBlockSize(), (char[])ExtentBufferUtil.copyToArray((BlockVolume)this, (Vector3i)this.getBlockMin(), (Vector3i)this.getBlockMax(), (Vector3i)this.getBlockSize()));
    }

    protected void deobfuscate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        boolean modified = false;
        for (int y = minY; y <= maxY; ++y) {
            NetworkBlockContainer container = this.containers[y >> 4];
            if (container == null) continue;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!container.deobfuscate(this.listener, x & 0xF, y & 0xF, z & 0xF)) continue;
                    modified = true;
                }
            }
        }
        if (modified) {
            this.saved = false;
        }
    }

    public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        return new MutableBlockViewDownsize((MutableBlockVolume)this, newMin, newMax);
    }

    public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new MutableBlockViewTransform((MutableBlockVolume)this, transform);
    }

    public MutableBlockVolumeWorker<? extends MutableBlockVolume> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker((MutableBlockVolume)this);
    }

    @Override
    public boolean areNeighborsLoaded() {
        return this.world.isChunkLoaded(this.x + 1, this.z) && this.world.isChunkLoaded(this.x, this.z + 1) && this.world.isChunkLoaded(this.x - 1, this.z) && this.world.isChunkLoaded(this.x, this.z - 1);
    }

    @Override
    public void reobfuscateArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean silentFail) {
        this.checkBlockArea(minX, minY, minZ, maxX, maxY, maxZ);
        if (this.state != ChunkView.State.OBFUSCATED) {
            if (silentFail) {
                return;
            }
            throw new IllegalStateException("Chunk must be fully obfuscated");
        }
        this.reobfuscate(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void reobfuscate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.deobfuscate(minX, minY, minZ, maxX, maxY, maxZ);
        Vector3i min = new Vector3i(minX, minY, minZ);
        Vector3i max = new Vector3i(maxX, maxY, maxZ);
        MirageTimings.REOBFUSCATION.startTiming();
        for (ConfiguredModifier mod : this.world.getModifiers()) {
            Timing timing = mod.modifier.getTiming();
            timing.startTiming();
            try {
                mod.modifier.modify(this, min, max, this.random, mod.config);
            }
            catch (Exception ex) {
                Mirage.LOGGER.error("Modifier " + mod.modifier.getId() + " has thrown an exception while (re)modifying a part of a network chunk", (Throwable)ex);
            }
            timing.stopTiming();
        }
        MirageTimings.REOBFUSCATION.stopTiming();
    }

    @Override
    public void clearDynamism() {
        for (NetworkBlockContainer c : this.containers) {
            if (c == null) continue;
            c.clearDynamism();
        }
        if (this.listener != null) {
            this.listener.clearDynamism();
        }
    }

    public BlockState getBlock(int x, int y, int z) {
        this.checkBlockPosition(x, y, z);
        NetworkBlockContainer c = this.containers[y >> 4];
        return c == null ? BlockTypes.AIR.getDefaultState() : (BlockState)c.get(x & 0xF, y & 0xF, z & 0xF);
    }

    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkBlockPosition(x, y, z);
        NetworkBlockContainer container = this.containers[y >> 4];
        if (container == null) {
            this.chunk.bindContainer(y >> 4);
            container = this.containers[y >> 4];
        }
        container.set(x & 0xF, y & 0xF, z & 0xF, (IBlockState)block);
        if (this.listener != null) {
            this.listener.addChange(x & 0xF, y, z & 0xF);
        }
        this.saved = false;
        return true;
    }

    public static long asLong(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }
}

