/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.MirageTimings;
import net.smoofyuniverse.mirage.api.cache.Signature;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifier;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifierRegistryModule;
import net.smoofyuniverse.mirage.api.modifier.ConfiguredModifier;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.api.volume.WorldView;
import net.smoofyuniverse.mirage.config.world.WorldConfig;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.internal.InternalWorld;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import net.smoofyuniverse.mirage.impl.network.cache.ChunkSnapshot;
import net.smoofyuniverse.mirage.impl.network.cache.NetworkRegionCache;
import net.smoofyuniverse.mirage.resource.Resources;
import net.smoofyuniverse.mirage.util.IOUtil;
import net.smoofyuniverse.mirage.util.MathUtil;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.extent.BlockVolume;
import org.spongepowered.api.world.extent.ImmutableBlockVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.gen.ArrayImmutableBlockBuffer;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.extent.ExtentBufferUtil;
import org.spongepowered.common.world.extent.MutableBlockViewDownsize;
import org.spongepowered.common.world.extent.MutableBlockViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBlockVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.GlobalPalette;

public class NetworkWorld
implements WorldView {
    public static final int CURRENT_CONFIG_VERSION = 2;
    public static final int MINIMUM_CONFIG_VERSION = 1;
    private final Long2ObjectMap<ChunkSnapshot> chunksToSave = new Long2ObjectOpenHashMap();
    private final Vector3i blockMin;
    private final Vector3i blockMax;
    private final Vector3i blockSize;
    private final InternalWorld world;
    private List<ConfiguredModifier> modifiers;
    private NetworkRegionCache regionCache;
    private WorldConfig.Immutable config;
    private Signature signature;
    private boolean enabled;
    private boolean dynamismEnabled;
    private Random random = new Random();

    public NetworkWorld(InternalWorld world) {
        this.world = world;
        this.blockMin = world.getBlockMin();
        this.blockMax = world.getBlockMax();
        this.blockSize = world.getBlockSize();
    }

    public void loadConfig() throws IOException, ObjectMappingException {
        CommentedConfigurationNode cfgNode;
        WorldConfig cfg;
        int version;
        CommentedConfigurationNode root;
        ConfigurationLoader<CommentedConfigurationNode> loader;
        block29: {
            if (this.config != null) {
                throw new IllegalStateException("Config already loaded");
            }
            Path file = Mirage.get().getWorldConfigsDirectory().resolve(this.getName() + ".conf");
            loader = Mirage.get().createConfigLoader(file);
            WorldProperties properties = this.getProperties();
            DimensionType dimType = properties.getDimensionType();
            WorldType wType = ((World)this.world).func_175624_G();
            root = (CommentedConfigurationNode)loader.load();
            version = root.getNode(new Object[]{"Version"}).getInt();
            if (version > 2 || version < 1) {
                version = 2;
                if (IOUtil.backupFile(file)) {
                    Mirage.LOGGER.info("Your config version is not supported. A new one will be generated.");
                    root = (CommentedConfigurationNode)loader.createEmptyNode();
                }
            }
            if ((cfg = (WorldConfig)(cfgNode = root.getNode(new Object[]{"Config"})).getValue(WorldConfig.TOKEN)) == null) {
                cfg = new WorldConfig(wType != WorldType.field_77138_c && wType != WorldType.field_180272_g && dimType != DimensionTypes.THE_END);
            }
            if (cfg.preobf.blocks == null) {
                cfg.preobf.blocks = Resources.of(dimType).getBlocks("common", "rare");
            }
            if (cfg.preobf.replacement == null) {
                cfg.preobf.replacement = Resources.of(dimType).getGround();
            }
            cfg.deobf.naturalRadius = MathUtil.clamp(cfg.deobf.naturalRadius, 1, 4);
            cfg.deobf.playerRadius = MathUtil.clamp(cfg.deobf.playerRadius, 1, 4);
            if (cfg.seed == 0L) {
                cfg.seed = ThreadLocalRandom.current().nextLong();
            }
            if (cfg.enabled && wType == WorldType.field_180272_g) {
                Mirage.LOGGER.warn("Obfuscation is not available in a debug_all_block_states world. Obfuscation will be disabled.");
                cfg.enabled = false;
            }
            CommentedConfigurationNode modsNode = root.getNode(new Object[]{"Modifiers"});
            if (version == 1) {
                for (Object node : modsNode.getChildrenList()) {
                    ConfigurationNode configurationNode;
                    ConfigurationNode typeNode = node.getNode(new Object[]{"Type"});
                    if (!typeNode.isVirtual() || (configurationNode = node.getNode(new Object[]{"Id"})).isVirtual()) continue;
                    typeNode.setValue(configurationNode.getValue());
                    node.removeChild((Object)"Id");
                }
                version = 2;
            }
            if (modsNode.isVirtual()) {
                if (dimType == DimensionTypes.OVERWORLD) {
                    modsNode.getAppendedNode().getNode(new Object[]{"Type"}).setValue((Object)"bedrock");
                    ConfigurationNode water_dungeons = modsNode.getAppendedNode();
                    water_dungeons.getNode(new Object[]{"Type"}).setValue((Object)"obvious");
                    water_dungeons.getNode(new Object[]{"Preset"}).setValue((Object)"water_dungeons");
                }
                modsNode.getAppendedNode().getNode(new Object[]{"Type"}).setValue((Object)"obvious");
            }
            ImmutableList.Builder mods = ImmutableList.builder();
            if (cfg.enabled) {
                for (Object node : modsNode.getChildrenList()) {
                    Object modCfg;
                    String string = node.getNode(new Object[]{"Type"}).getString();
                    if (string == null) continue;
                    ChunkModifier chunkModifier = ChunkModifierRegistryModule.get().getById(string).orElse(null);
                    if (chunkModifier == null) {
                        Mirage.LOGGER.warn("Modifier '" + string + "' does not exists.");
                        continue;
                    }
                    if (!chunkModifier.isCompatible(properties)) {
                        Mirage.LOGGER.warn("Modifier " + chunkModifier.getId() + " is not compatible with this world. This modifier will be ignored.");
                        continue;
                    }
                    try {
                        String preset = node.getNode(new Object[]{"Preset"}).getString();
                        modCfg = chunkModifier.loadConfiguration(node.getNode(new Object[]{"Options"}), properties, preset == null ? "" : preset.toLowerCase());
                        node.removeChild((Object)"Preset");
                    }
                    catch (Exception e) {
                        Mirage.LOGGER.warn("Modifier " + chunkModifier.getId() + " failed to loaded his configuration. This modifier will be ignored.", (Throwable)e);
                        continue;
                    }
                    mods.add((Object)new ConfiguredModifier(chunkModifier, modCfg));
                }
            }
            this.modifiers = mods.build();
            if (cfg.enabled && this.modifiers.isEmpty()) {
                Mirage.LOGGER.info("No valid modifier was found. Obfuscation will be disabled.");
                cfg.enabled = false;
            }
            if (cfg.enabled && cfg.cache) {
                boolean useCache = false;
                for (ConfiguredModifier configuredModifier : this.modifiers) {
                    if (!configuredModifier.modifier.shouldCache()) continue;
                    useCache = true;
                }
                if (useCache) {
                    Signature.Builder cacheSignature = Signature.builder();
                    for (ConfiguredModifier configuredModifier : this.modifiers) {
                        cacheSignature.append(configuredModifier.modifier);
                    }
                    String string = this.world.getUniqueId() + "/" + cacheSignature.build();
                    this.regionCache = new NetworkRegionCache(Mirage.get().getCacheDirectory().resolve(string));
                    try {
                        this.regionCache.loadVersion();
                        if (this.regionCache.isVersionSupported()) {
                            if (this.regionCache.shouldUpdateVersion()) {
                                Mirage.LOGGER.info("Updating cache version in directory " + string + "/ ..");
                                this.regionCache.updateVersion();
                            }
                            this.regionCache.saveVersion();
                            Signature.Builder builder = Signature.builder().append(cfg.seed).append((byte)(cfg.dynamism ? 1 : 0));
                            for (ConfiguredModifier mod : this.modifiers) {
                                mod.modifier.appendSignature(builder, mod.config);
                            }
                            this.signature = builder.build();
                            break block29;
                        }
                        Mirage.LOGGER.warn("Cache version in directory " + string + "/ is not supported. Caching will be disabled.");
                        this.regionCache = null;
                    }
                    catch (Exception exception) {
                        Mirage.LOGGER.warn("Failed to load cache in directory " + string + "/. Caching will be disabled.", (Throwable)exception);
                        this.regionCache = null;
                    }
                } else {
                    Mirage.LOGGER.info("No modifier needing caching was found. Caching will be disabled.");
                    cfg.cache = false;
                }
            }
        }
        root.getNode(new Object[]{"Version"}).setValue((Object)version);
        cfgNode.setValue(WorldConfig.TOKEN, (Object)cfg);
        loader.save((ConfigurationNode)root);
        this.config = cfg.toImmutable();
        this.enabled = cfg.enabled;
        this.dynamismEnabled = cfg.enabled && cfg.dynamism;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean useCache() {
        return this.regionCache != null;
    }

    @Nullable
    public Signature getSignature() {
        return this.signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingSave(int x, int z, ChunkSnapshot chunk) {
        if (this.regionCache == null) {
            return;
        }
        Long2ObjectMap<ChunkSnapshot> long2ObjectMap = this.chunksToSave;
        synchronized (long2ObjectMap) {
            this.chunksToSave.put(NetworkChunk.asLong(x, z), (Object)chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePendingSave(int x, int z) {
        if (this.regionCache == null) {
            return;
        }
        Long2ObjectMap<ChunkSnapshot> long2ObjectMap = this.chunksToSave;
        synchronized (long2ObjectMap) {
            this.chunksToSave.remove(NetworkChunk.asLong(x, z));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingChunk(int x, int z) {
        ChunkSnapshot chunk;
        if (this.regionCache == null) {
            return;
        }
        Long2ObjectMap<ChunkSnapshot> long2ObjectMap = this.chunksToSave;
        synchronized (long2ObjectMap) {
            chunk = (ChunkSnapshot)this.chunksToSave.remove(NetworkChunk.asLong(x, z));
        }
        if (chunk != null) {
            this.saveToCache(x, z, chunk);
        }
    }

    public void saveToCache(int x, int z, ChunkSnapshot chunk) {
        if (this.regionCache == null) {
            throw new IllegalStateException();
        }
        MirageTimings.WRITING_CACHE.startTimingIfSync();
        try (DataOutputStream out = this.regionCache.getChunkOutputStream(x, z);){
            this.signature.write(out);
            chunk.write(out);
        }
        catch (Exception e) {
            Mirage.LOGGER.warn("Failed to save chunk data " + x + " " + z + " to cache in world " + this.world.getName() + ".", (Throwable)e);
        }
        if (SpongeImpl.getServer().func_152345_ab()) {
            MirageTimings.WRITING_CACHE.stopTimingIfSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ChunkSnapshot readFromCache(int x, int z) {
        if (this.regionCache == null) {
            throw new IllegalStateException();
        }
        MirageTimings.READING_CACHE.startTimingIfSync();
        try (DataInputStream in = this.regionCache.getChunkInputStream(x, z);){
            if (in != null && Signature.read(in).equals(this.signature)) {
                ChunkSnapshot chunkSnapshot = new ChunkSnapshot().read(in);
                return chunkSnapshot;
            }
        }
        catch (Exception e) {
            Mirage.LOGGER.warn("Failed to read chunk data " + x + " " + z + " from cache in world " + this.world.getName() + ".", (Throwable)e);
        }
        finally {
            MirageTimings.READING_CACHE.stopTimingIfSync();
        }
        return null;
    }

    @Override
    public InternalWorld getStorage() {
        return this.world;
    }

    @Override
    public boolean isDynamismEnabled() {
        return this.dynamismEnabled;
    }

    @Override
    public void setDynamism(int x, int y, int z, int distance) {
        NetworkChunk chunk;
        if (this.dynamismEnabled && (chunk = this.getChunk(x >> 4, z >> 4)) != null) {
            chunk.setDynamism(x, y, z, distance);
        }
    }

    @Override
    public int getDynamism(int x, int y, int z) {
        if (!this.dynamismEnabled) {
            return 0;
        }
        NetworkChunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk == null ? 0 : chunk.getDynamism(x, y, z);
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public WorldProperties getProperties() {
        return this.world.getProperties();
    }

    @Override
    public List<ConfiguredModifier> getModifiers() {
        if (this.config == null) {
            throw new IllegalStateException("Config not loaded");
        }
        return this.modifiers;
    }

    @Override
    public WorldConfig.Immutable getConfig() {
        if (this.config == null) {
            throw new IllegalStateException("Config not loaded");
        }
        return this.config;
    }

    @Override
    public Optional<ChunkView> getChunkView(int x, int y, int z) {
        return Optional.ofNullable(this.getChunk(x, z));
    }

    @Override
    public Optional<ChunkView> getChunkViewAt(int x, int y, int z) {
        return this.getChunkView(x >> 4, 0, z >> 4);
    }

    public Collection<NetworkChunk> getLoadedChunkViews() {
        if (!this.enabled) {
            return ImmutableList.of();
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (InternalChunk c : this.world.getLoadedChunkStorages()) {
            if (!c.isViewAvailable()) continue;
            b.add((Object)c.getView());
        }
        return b.build();
    }

    @Override
    public boolean deobfuscate(int x, int y, int z) {
        NetworkChunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk != null && chunk.deobfuscate(x, y, z);
    }

    @Override
    public void deobfuscateArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean silentFail) {
        this.checkBlockArea(minX, minY, minZ, maxX, maxY, maxZ);
        if (!this.enabled) {
            return;
        }
        int minChunkX = minX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkX = maxX >> 4;
        int maxChunkZ = maxZ >> 4;
        if (minChunkX == maxChunkX && minChunkZ == maxChunkZ) {
            NetworkChunk chunk = this.getChunk(minChunkX, minChunkZ);
            if (chunk == null) {
                if (silentFail) {
                    return;
                }
                throw new IllegalStateException("Chunk must be loaded");
            }
            if (chunk.getState() != ChunkView.State.DEOBFUSCATED) {
                chunk.deobfuscate(minX, minY, minZ, maxX, maxY, maxZ);
            }
            return;
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (this.getChunk(chunkX, chunkZ) != null) continue;
                if (silentFail) {
                    return;
                }
                throw new IllegalStateException("Chunks must be loaded");
            }
        }
        this.deobfuscate(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private void deobfuscate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int minChunkX = minX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkX = maxX >> 4;
        int maxChunkZ = maxZ >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                NetworkChunk chunk = this.getChunk(chunkX, chunkZ);
                if (chunk.getState() == ChunkView.State.DEOBFUSCATED) continue;
                int chunkMinX = chunkX << 4;
                int chunkMinZ = chunkZ << 4;
                chunk.deobfuscate(Math.max(minX, chunkMinX), minY, Math.max(minZ, chunkMinZ), Math.min(maxX, chunkMinX + 15), maxY, Math.min(maxZ, chunkMinZ + 15));
            }
        }
    }

    @Override
    public void reobfuscateArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean silentFail) {
        this.checkBlockArea(minX, minY, minZ, maxX, maxY, maxZ);
        if (!this.enabled) {
            return;
        }
        int minChunkX = minX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkX = maxX >> 4;
        int maxChunkZ = maxZ >> 4;
        if (minChunkX == maxChunkX && minChunkZ == maxChunkZ) {
            NetworkChunk chunk = this.getChunk(minChunkX, minChunkZ);
            if (chunk == null) {
                if (silentFail) {
                    return;
                }
                throw new IllegalStateException("Chunk must be loaded");
            }
            if (chunk.getState() != ChunkView.State.OBFUSCATED) {
                if (silentFail) {
                    return;
                }
                throw new IllegalStateException("Chunk must be fully obfuscated");
            }
            chunk.reobfuscate(minX, minY, minZ, maxX, maxY, maxZ);
            return;
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                NetworkChunk chunk = this.getChunk(chunkX, chunkZ);
                if (chunk == null) {
                    if (silentFail) {
                        return;
                    }
                    throw new IllegalStateException("Chunks must be loaded");
                }
                if (chunk.getState() == ChunkView.State.OBFUSCATED) continue;
                if (silentFail) {
                    return;
                }
                throw new IllegalStateException("Chunks must be fully obfuscated");
            }
        }
        this.deobfuscate(minX, minY, minZ, maxX, maxY, maxZ);
        Vector3i min = new Vector3i(minX, minY, minZ);
        Vector3i max = new Vector3i(maxX, maxY, maxZ);
        MirageTimings.REOBFUSCATION.startTiming();
        for (ConfiguredModifier mod : this.getModifiers()) {
            Timing timing = mod.modifier.getTiming();
            timing.startTiming();
            try {
                mod.modifier.modify(this, min, max, this.random, mod.config);
            }
            catch (Exception ex) {
                Mirage.LOGGER.error("Modifier " + mod.modifier.getId() + " has thrown an exception while (re)modifying a part of a network world", (Throwable)ex);
            }
            timing.stopTiming();
        }
        MirageTimings.REOBFUSCATION.stopTiming();
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.getChunk(x, z) != null;
    }

    @Nullable
    public NetworkChunk getChunk(int x, int z) {
        InternalChunk chunk = this.world.getChunk(x, z);
        return chunk != null && chunk.isViewAvailable() ? chunk.getView() : null;
    }

    @Override
    public boolean isExposed(int x, int y, int z) {
        NetworkChunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk != null && chunk.isExposed(x, y, z);
    }

    public boolean setBlock(int x, int y, int z, BlockState block) {
        NetworkChunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk != null && chunk.setBlock(x, y, z, block);
    }

    public MutableBlockVolume getBlockView(Vector3i newMin, Vector3i newMax) {
        return new MutableBlockViewDownsize((MutableBlockVolume)this, newMin, newMax);
    }

    public MutableBlockVolume getBlockView(DiscreteTransform3 transform) {
        return new MutableBlockViewTransform((MutableBlockVolume)this, transform);
    }

    public MutableBlockVolumeWorker<? extends MutableBlockVolume> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker((MutableBlockVolume)this);
    }

    public Vector3i getBlockMin() {
        return this.blockMin;
    }

    public Vector3i getBlockMax() {
        return this.blockMax;
    }

    public Vector3i getBlockSize() {
        return this.blockSize;
    }

    public boolean containsBlock(int x, int y, int z) {
        return VecHelper.inBounds((int)x, (int)y, (int)z, (Vector3i)this.blockMin, (Vector3i)this.blockMax);
    }

    public BlockState getBlock(int x, int y, int z) {
        NetworkChunk chunk = this.getChunk(x >> 4, z >> 4);
        return chunk == null ? BlockTypes.AIR.getDefaultState() : chunk.getBlock(x, y, z);
    }

    public BlockType getBlockType(int x, int y, int z) {
        return this.getBlock(x, y, z).getType();
    }

    public UnmodifiableBlockVolume getUnmodifiableBlockView() {
        return new UnmodifiableBlockVolumeWrapper((MutableBlockVolume)this);
    }

    public MutableBlockVolume getBlockCopy(StorageType type) {
        switch (type) {
            case STANDARD: {
                return new ArrayMutableBlockBuffer(GlobalPalette.getBlockPalette(), this.blockMin, this.blockMax, ExtentBufferUtil.copyToArray((BlockVolume)this, (Vector3i)this.blockMin, (Vector3i)this.blockMax, (Vector3i)this.blockSize));
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    public ImmutableBlockVolume getImmutableBlockCopy() {
        return ArrayImmutableBlockBuffer.newWithoutArrayClone((Palette)GlobalPalette.getBlockPalette(), (Vector3i)this.blockMin, (Vector3i)this.blockMax, (char[])ExtentBufferUtil.copyToArray((BlockVolume)this, (Vector3i)this.blockMin, (Vector3i)this.blockMax, (Vector3i)this.blockSize));
    }

    public UUID getUniqueId() {
        return this.world.getUniqueId();
    }
}

