/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.impl.network.cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import net.smoofyuniverse.mirage.impl.network.cache.NetworkRegionFile;

public class NetworkRegionCache {
    public static final int CURRENT_VERSION = 2;
    public static final int MINIMUM_VERSION = 1;
    private final Long2ObjectMap<NetworkRegionFile> loadedRegions = new Long2ObjectOpenHashMap();
    private final Path dir;
    private int version = -1;

    public NetworkRegionCache(Path dir) {
        this.dir = dir;
        try {
            Files.createDirectories(this.dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadVersion() throws IOException {
        if (this.version == -1) {
            Path file = this.dir.resolve("version");
            if (Files.exists(file, new LinkOption[0])) {
                try (DataInputStream in = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                    this.version = in.readInt();
                }
            }
            try (DirectoryStream<Path> st = Files.newDirectoryStream(this.dir);){
                this.version = st.iterator().hasNext() ? 0 : 2;
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isVersionSupported() {
        return this.version >= 1 && this.version <= 2;
    }

    public boolean shouldUpdateVersion() {
        return this.version != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVersion() throws IOException {
        if (this.version < 1 || this.version > 2) {
            throw new UnsupportedOperationException();
        }
        if (this.version == 2) {
            return;
        }
        Long2ObjectMap<NetworkRegionFile> long2ObjectMap = this.loadedRegions;
        synchronized (long2ObjectMap) {
            if (!this.loadedRegions.isEmpty()) {
                throw new IllegalStateException();
            }
        }
        if (this.version == 1) {
            this.deleteRegionFiles();
            this.version = 2;
        }
    }

    private void deleteRegionFiles() throws IOException {
        IOException error = null;
        try (DirectoryStream<Path> st = Files.newDirectoryStream(this.dir);){
            for (Path p : st) {
                if (!NetworkRegionCache.isRegionFile(p.getFileName().toString())) continue;
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    error = e;
                }
            }
        }
        catch (DirectoryIteratorException e) {
            throw e.getCause();
        }
        if (error != null) {
            throw error;
        }
    }

    public void saveVersion() throws IOException {
        Path file = this.dir.resolve("version");
        try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            out.writeInt(this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NetworkRegionFile getIfLoaded(int x, int z) {
        Long2ObjectMap<NetworkRegionFile> long2ObjectMap = this.loadedRegions;
        synchronized (long2ObjectMap) {
            return (NetworkRegionFile)this.loadedRegions.get(NetworkChunk.asLong(x, z));
        }
    }

    @Nullable
    public DataInputStream getChunkInputStream(int cx, int cz) {
        NetworkRegionFile file = this.getOrLoad(cx >> 5, cz >> 5);
        return file == null ? null : file.getDataInputStream(cx & 0x1F, cz & 0x1F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public NetworkRegionFile getOrLoad(int x, int z) {
        Long2ObjectMap<NetworkRegionFile> long2ObjectMap = this.loadedRegions;
        synchronized (long2ObjectMap) {
            long pos = NetworkChunk.asLong(x, z);
            NetworkRegionFile file = (NetworkRegionFile)this.loadedRegions.get(pos);
            if (file != null) {
                return file;
            }
            Path p = this.getRegionFile(x, z);
            if (!Files.exists(p, new LinkOption[0])) {
                return null;
            }
            if (this.loadedRegions.size() >= 32) {
                this.closeLoadedRegions();
            }
            file = new NetworkRegionFile(p);
            this.loadedRegions.put(pos, (Object)file);
            return file;
        }
    }

    private Path getRegionFile(int x, int z) {
        return this.dir.resolve("r." + x + "." + z + ".dat");
    }

    private static boolean isRegionFile(String name) {
        if (name.startsWith("r.") && name.endsWith(".dat")) {
            String pos = name.substring(2, name.length() - 4);
            int i = pos.indexOf(46);
            if (i == -1) {
                return false;
            }
            try {
                Integer.parseInt(pos.substring(0, i));
                Integer.parseInt(pos.substring(i + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLoadedRegions() {
        Long2ObjectMap<NetworkRegionFile> long2ObjectMap = this.loadedRegions;
        synchronized (long2ObjectMap) {
            for (NetworkRegionFile file : this.loadedRegions.values()) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    Mirage.LOGGER.warn("Failed to close region file " + file.getFile().getFileName(), (Throwable)e);
                }
            }
            this.loadedRegions.clear();
        }
    }

    public DataOutputStream getChunkOutputStream(int cx, int cz) {
        return this.getOrCreate(cx >> 5, cz >> 5).getDataOutputStream(cx & 0x1F, cz & 0x1F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkRegionFile getOrCreate(int x, int z) {
        Long2ObjectMap<NetworkRegionFile> long2ObjectMap = this.loadedRegions;
        synchronized (long2ObjectMap) {
            long pos = NetworkChunk.asLong(x, z);
            NetworkRegionFile file = (NetworkRegionFile)this.loadedRegions.get(pos);
            if (file != null) {
                return file;
            }
            if (this.loadedRegions.size() >= 32) {
                this.closeLoadedRegions();
            }
            file = new NetworkRegionFile(this.getRegionFile(x, z));
            this.loadedRegions.put(pos, (Object)file);
            return file;
        }
    }
}

