/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.mixin.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.world.WorldServer;
import net.smoofyuniverse.mirage.impl.internal.InternalChunkMap;
import net.smoofyuniverse.mirage.impl.internal.InternalWorld;
import net.smoofyuniverse.mirage.impl.network.dynamism.PlayerDynamismManager;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerChunkMap.class})
public class MixinPlayerChunkMap
implements InternalChunkMap {
    @Shadow
    @Final
    private WorldServer field_72701_a;
    private Map<UUID, PlayerDynamismManager> dynamismManagers = new HashMap<UUID, PlayerDynamismManager>();

    @Override
    public boolean isDynamismEnabled() {
        return ((InternalWorld)this.field_72701_a).getView().isDynamismEnabled();
    }

    @Override
    public PlayerDynamismManager getOrCreateDynamismManager(Player player) {
        PlayerDynamismManager manager = this.dynamismManagers.get(player.getUniqueId());
        if (manager == null) {
            if (!this.isDynamismEnabled()) {
                throw new UnsupportedOperationException();
            }
            manager = new PlayerDynamismManager(player.getUniqueId());
            manager.setCenter(player.getPosition().toInt());
            this.dynamismManagers.put(manager.playerId, manager);
        }
        return manager;
    }

    @Override
    public Optional<PlayerDynamismManager> getDynamismManager(UUID id) {
        return Optional.ofNullable(this.dynamismManagers.get(id));
    }

    @Override
    public Optional<PlayerDynamismManager> removeDynamismManager(UUID id) {
        return Optional.ofNullable(this.dynamismManagers.remove(id));
    }

    @Inject(method={"removePlayer"}, at={@At(value="INVOKE", target="Ljava/util/List;remove(Ljava/lang/Object;)Z")})
    public void onRemovePlayer(EntityPlayerMP player, CallbackInfo ci) {
        if (this.isDynamismEnabled()) {
            this.removeDynamismManager(player.func_110124_au());
        }
    }

    @Inject(method={"updateMovingPlayer"}, at={@At(value="RETURN")})
    public void onUpdateMovingPlayer(EntityPlayerMP player, CallbackInfo ci) {
        if (this.isDynamismEnabled()) {
            this.getDynamismManager(player.func_110124_au()).ifPresent(m -> m.update((Player)player));
        }
    }
}

