/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.mixin.world;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.internal.InternalWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AnvilChunkLoader.class})
public class MixinAnvilChunkLoader {
    private InternalWorld world;

    @Inject(method={"writeChunkToNBT"}, at={@At(value="RETURN")})
    public void onWriteChunkToNBT(Chunk chunk, World world, NBTTagCompound compound, CallbackInfo ci) {
        if (this.world == null) {
            this.world = (InternalWorld)world;
        } else if (this.world != world) {
            Mirage.LOGGER.warn("World change detected in an AnvilChunkLoader! This is going to generate caching errors");
        }
        try {
            InternalChunk internalChunk = (InternalChunk)chunk;
            if (internalChunk.isViewAvailable()) {
                internalChunk.getView().saveToCacheLater();
                compound.func_74772_a("MirageCacheDate", internalChunk.getValidCacheDate());
            }
        }
        catch (Exception e) {
            Mirage.LOGGER.error("Failed to serialize a network chunk for caching", (Throwable)e);
        }
    }

    @Inject(method={"readChunkFromNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;getIntArray(Ljava/lang/String;)[I", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onReadChunkFromNBT(World world, NBTTagCompound compound, CallbackInfoReturnable<Chunk> ci, int cx, int cz, Chunk chunk) {
        ((InternalChunk)chunk).setValidCacheDate(compound.func_74763_f("MirageCacheDate"));
    }

    @Inject(method={"writeChunkData"}, at={@At(value="RETURN")})
    public void onWriteChunkData(ChunkPos pos, NBTTagCompound compound, CallbackInfo ci) {
        try {
            this.world.getView().savePendingChunk(pos.field_77276_a, pos.field_77275_b);
        }
        catch (Exception e) {
            Mirage.LOGGER.error("Failed to save a pending network chunk", (Throwable)e);
        }
    }
}

