/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.mixin.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.world.chunk.BlockStateContainer;
import net.smoofyuniverse.mirage.impl.internal.InternalBlockContainer;
import net.smoofyuniverse.mirage.impl.network.NetworkBlockContainer;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockStateContainer.class})
public class MixinBlockStateContainer
implements InternalBlockContainer {
    private NetworkBlockContainer networkContainer = new NetworkBlockContainer((BlockStateContainer)this);
    private NetworkChunk chunk;

    @Override
    public void setNetworkChunk(NetworkChunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public NetworkBlockContainer getNetworkBlockContainer() {
        return this.networkContainer;
    }

    @Inject(method={"set(ILnet/minecraft/block/state/IBlockState;)V"}, at={@At(value="RETURN")})
    public void onSet(int index, IBlockState state, CallbackInfo ci) {
        this.networkContainer.set(index, state);
        if (this.chunk != null) {
            this.chunk.setSaved(false);
        }
    }

    @Inject(method={"setBits(I)V"}, at={@At(value="HEAD")})
    public void onSetBits(int bits, CallbackInfo ci) {
        this.networkContainer.setBits(bits);
    }
}

