/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.mixin.world;

import com.flowpowered.math.vector.Vector2i;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.impl.internal.InternalBlockState;
import net.smoofyuniverse.mirage.impl.internal.InternalChunk;
import net.smoofyuniverse.mirage.impl.internal.InternalWorld;
import net.smoofyuniverse.mirage.impl.network.NetworkChunk;
import net.smoofyuniverse.mirage.impl.network.NetworkWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.world.SpongeEmptyChunk;

@Mixin(value={Chunk.class}, priority=1100)
public abstract class MixinChunk
implements InternalChunk {
    @Shadow
    @Final
    public int field_76635_g;
    @Shadow
    @Final
    public int field_76647_h;
    @Shadow
    @Final
    private ExtendedBlockStorage[] field_76652_q;
    @Shadow
    @Final
    private World field_76637_e;
    @Shadow
    private boolean field_76643_l;
    private final Object containersLock = new Object();
    private NetworkChunk netChunk;
    private long cacheDate;

    @Shadow
    public abstract IBlockState func_186032_a(int var1, int var2, int var3);

    @Shadow
    public abstract int func_76611_b(int var1, int var2);

    @Shadow
    public abstract int func_177413_a(EnumSkyBlock var1, BlockPos var2);

    @Shadow
    public abstract void func_76603_b();

    @Inject(method={"<init>(Lnet/minecraft/world/World;II)V"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        if (this instanceof SpongeEmptyChunk) {
            return;
        }
        NetworkWorld netWorld = ((InternalWorld)this.field_76637_e).getView();
        if (netWorld.isEnabled()) {
            this.netChunk = new NetworkChunk(this, netWorld);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/world/chunk/ChunkPrimer;II)V"}, at={@At(value="RETURN")})
    public void onInitWithPrimer(CallbackInfo ci) {
        this.bindContainers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bindContainers() {
        if (this.netChunk == null) {
            return false;
        }
        try {
            Object object = this.containersLock;
            synchronized (object) {
                this.netChunk.setContainers(this.field_76652_q);
            }
            return true;
        }
        catch (Exception e) {
            Mirage.LOGGER.error("Failed to set containers of a network chunk", (Throwable)e);
            return false;
        }
    }

    @Inject(method={"setStorageArrays"}, at={@At(value="RETURN")})
    public void onSetStorageArrays(CallbackInfo ci) {
        if (this.bindContainers()) {
            try {
                if (this.netChunk.getState() != ChunkView.State.OBFUSCATED) {
                    this.netChunk.loadFromCacheNow();
                }
            }
            catch (Exception e) {
                Mirage.LOGGER.error("Failed to load a network chunk from cache", (Throwable)e);
            }
        }
    }

    @Override
    public NetworkChunk getView() {
        if (this.netChunk == null) {
            throw new IllegalStateException("NetworkChunk not available");
        }
        return this.netChunk;
    }

    @Override
    public boolean isViewAvailable() {
        return this.netChunk != null;
    }

    @Override
    public long getValidCacheDate() {
        return this.cacheDate;
    }

    @Override
    public InternalWorld getWorld() {
        return (InternalWorld)this.field_76637_e;
    }

    @Override
    public void setValidCacheDate(long value) {
        this.cacheDate = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindContainer(int index) {
        if (this.netChunk == null) {
            return;
        }
        Object object = this.containersLock;
        synchronized (object) {
            if (this.netChunk.needContainer(index)) {
                ExtendedBlockStorage storage = this.field_76652_q[index];
                if (storage == null) {
                    storage = new ExtendedBlockStorage(index << 4, this.field_76637_e.field_73011_w.func_191066_m());
                    this.netChunk.setContainer(index, storage);
                    this.field_76652_q[index] = storage;
                    this.func_76603_b();
                } else {
                    this.netChunk.setContainer(index, storage);
                    if (!storage.func_76663_a()) {
                        this.netChunk.setSaved(false);
                    }
                }
            }
        }
    }

    @Redirect(method={"bridge$setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/block/state/IBlockState;Lorg/spongepowered/api/world/BlockChangeFlag;)Lnet/minecraft/block/state/IBlockState;"}, at=@At(value="NEW", target="net/minecraft/world/chunk/storage/ExtendedBlockStorage"), remap=false)
    public ExtendedBlockStorage onBlockChange_newStorage(int y, boolean storeSkylight) {
        return this.createStorage(y >> 4, storeSkylight);
    }

    @Redirect(method={"bridge$fill(Lnet/minecraft/world/chunk/ChunkPrimer;)V"}, at=@At(value="NEW", target="net/minecraft/world/chunk/storage/ExtendedBlockStorage"), remap=false)
    public ExtendedBlockStorage onFill_newStorage(int y, boolean storeSkylight) {
        return this.createStorage(y >> 4, storeSkylight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedBlockStorage createStorage(int index, boolean storeSkylight) {
        ExtendedBlockStorage storage = new ExtendedBlockStorage(index << 4, storeSkylight);
        if (this.netChunk != null) {
            try {
                Object object = this.containersLock;
                synchronized (object) {
                    if (this.netChunk.needContainer(index)) {
                        this.netChunk.setContainer(index, storage);
                        if (!storage.func_76663_a()) {
                            this.netChunk.setSaved(false);
                        }
                    }
                }
            }
            catch (Exception e) {
                Mirage.LOGGER.error("Failed to set a container of a network chunk", (Throwable)e);
            }
        }
        return storage;
    }

    @Redirect(method={"setLightFor"}, at=@At(value="NEW", target="net/minecraft/world/chunk/storage/ExtendedBlockStorage"))
    public ExtendedBlockStorage onLightChange_newStorage(int y, boolean storeSkylight) {
        return this.createStorage(y >> 4, storeSkylight);
    }

    @Override
    public boolean isExposed(int x, int y, int z) {
        InternalChunk c;
        this.checkBlockPosition(x, y, z);
        if (y == 255 || !this.isOpaque(x &= 0xF, y + 1, z &= 0xF)) {
            return true;
        }
        if (y == 0 || !this.isOpaque(x, y - 1, z)) {
            return true;
        }
        if (x == 15 ? (c = ((InternalWorld)this.field_76637_e).getChunk(this.field_76635_g + 1, this.field_76647_h)) == null || !c.isOpaque(0, y, z) : !this.isOpaque(x + 1, y, z)) {
            return true;
        }
        if (x == 0 ? (c = ((InternalWorld)this.field_76637_e).getChunk(this.field_76635_g - 1, this.field_76647_h)) == null || !c.isOpaque(15, y, z) : !this.isOpaque(x - 1, y, z)) {
            return true;
        }
        if (z == 15 ? (c = ((InternalWorld)this.field_76637_e).getChunk(this.field_76635_g, this.field_76647_h + 1)) == null || !c.isOpaque(x, y, 0) : !this.isOpaque(x, y, z + 1)) {
            return true;
        }
        return z == 0 ? (c = ((InternalWorld)this.field_76637_e).getChunk(this.field_76635_g, this.field_76647_h - 1)) == null || !c.isOpaque(x, y, 15) : !this.isOpaque(x, y, z - 1);
    }

    @Override
    public boolean isOpaque(int x, int y, int z) {
        ExtendedBlockStorage storage = this.field_76652_q[y >> 4];
        return storage != null && ((InternalBlockState)storage.func_177485_a(x, y & 0xF, z)).isOpaque();
    }

    @Override
    public Vector2i getLightLevels(int x, int y, int z) {
        this.checkBlockPosition(x, y, z);
        x &= 0xF;
        z &= 0xF;
        ExtendedBlockStorage storage = this.field_76652_q[y >> 4];
        if (storage == null) {
            return y >= this.func_76611_b(x & 0xF, z & 0xF) ? new Vector2i(0, 15) : Vector2i.ZERO;
        }
        return new Vector2i(storage.func_76674_d(x, y & 0xF, z), this.field_76637_e.field_73011_w.func_191066_m() ? storage.func_76670_c(x, y & 0xF, z) : 0);
    }

    @Override
    public int getHighestY(int x, int z) {
        this.checkBlockPosition(x, 0, z);
        return this.func_76611_b(x & 0xF, z & 0xF);
    }

    @Override
    public boolean areNeighborsLoaded() {
        InternalWorld w = (InternalWorld)this.field_76637_e;
        return w.isChunkLoaded(this.field_76635_g + 1, this.field_76647_h) && w.isChunkLoaded(this.field_76635_g, this.field_76647_h + 1) && w.isChunkLoaded(this.field_76635_g - 1, this.field_76647_h) && w.isChunkLoaded(this.field_76635_g, this.field_76647_h - 1);
    }
}

