/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.modifier;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.TrigMath;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.api.cache.Signature;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifier;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.api.volume.WorldView;
import net.smoofyuniverse.mirage.resource.Resources;
import net.smoofyuniverse.mirage.util.MathUtil;
import net.smoofyuniverse.mirage.util.collection.BlockSet;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.api.world.storage.WorldProperties;

public class FakeGenModifier
extends ChunkModifier {
    private static final float PI = (float)Math.PI;

    public FakeGenModifier() {
        super(Mirage.get(), "FakeGen");
    }

    @Override
    public Object loadConfiguration(ConfigurationNode node, WorldProperties world, String preset) throws ObjectMappingException {
        Config cfg = (Config)node.getValue(Config.TOKEN);
        if (cfg == null) {
            cfg = new Config();
        }
        if (cfg.blocks == null) {
            cfg.blocks = Resources.of(world).getBlocks("common");
        }
        cfg.density = MathUtil.clamp(cfg.density, 0.1, 10.0);
        cfg.dynamism = MathUtil.clamp(cfg.dynamism, 0, 10);
        cfg.minY = MathUtil.clamp(cfg.minY, 0, 255);
        cfg.maxY = MathUtil.clamp(cfg.maxY, 0, 255);
        if (cfg.minY > cfg.maxY) {
            int t = cfg.minY;
            cfg.minY = cfg.maxY;
            cfg.maxY = t;
        }
        node.setValue(Config.TOKEN, (Object)cfg);
        return cfg.toImmutable();
    }

    @Override
    public void appendSignature(Signature.Builder builder, Object config) {
        Config.Immutable cfg = (Config.Immutable)config;
        builder.append(cfg.blocks).append(cfg.density).append(cfg.dynamism).append(cfg.minY).append(cfg.maxY);
    }

    @Override
    public boolean isReady(ChunkView view, Object config) {
        return view.areNeighborsLoaded();
    }

    @Override
    public void modify(BlockView view, Vector3i min, Vector3i max, Random r, Object config) {
        WorldView worldView;
        Config.Immutable cfg = (Config.Immutable)config;
        boolean useDynamism = cfg.dynamism != 0 && view.isDynamismEnabled();
        int minX = min.getX();
        int minY = Math.max(min.getY(), cfg.minY);
        int minZ = min.getZ();
        int maxX = max.getX();
        int maxY = Math.min(max.getY(), cfg.maxY);
        int maxZ = max.getZ();
        if (minY > maxY) {
            return;
        }
        if (view instanceof WorldView) {
            worldView = (WorldView)view;
        } else if (view instanceof ChunkView) {
            worldView = ((ChunkView)view).getWorld();
        } else {
            throw new UnsupportedOperationException();
        }
        World world = (World)worldView.getStorage();
        WorldGenerator generator = world.getWorldGenerator();
        ArrayList<Ore> ores = new ArrayList<Ore>();
        for (Populator pop : generator.getPopulators()) {
            if (!(pop instanceof Ore) || !cfg.blocks.contains(((Ore)pop).getOreBlock())) continue;
            ores.add((Ore)pop);
        }
        ArrayList<Object> biomes = new ArrayList<Object>();
        for (int x = minX; x <= maxX; ++x) {
            for (int i = minZ; i <= maxZ; ++i) {
                BiomeType biome = world.getBiome(x, 0, i);
                if (biomes.contains(biome)) continue;
                biomes.add(biome);
            }
        }
        for (BiomeType biomeType : biomes) {
            for (Populator pop : generator.getBiomeSettings(biomeType).getPopulators()) {
                if (!(pop instanceof Ore) || !cfg.blocks.contains(((Ore)pop).getOreBlock())) continue;
                ores.add((Ore)pop);
            }
        }
        int sizeX = maxX - minX + 1;
        int n = maxZ - minZ + 1;
        double factor = cfg.density * (double)sizeX * (double)n / 256.0;
        int worldMinY = worldView.getBlockMin().getY();
        int worldMaxY = worldView.getBlockMax().getY();
        for (Ore ore : ores) {
            int amountI;
            double amountD = ore.getDepositsPerChunk().getAmount(r) * factor;
            double dif = amountD - (double)(amountI = (int)amountD);
            if (dif != 0.0 && r.nextDouble() < dif) {
                ++amountI;
            }
            Predicate predicate = ore.getPlacementCondition();
            BlockState block = ore.getOreBlock();
            for (int n2 = 0; n2 < amountI; ++n2) {
                int posX = minX + r.nextInt(sizeX);
                int posY = ore.getHeight().getFlooredAmount(r);
                int posZ = minZ + r.nextInt(n);
                if (posY < minY || posY > maxY) continue;
                int size = ore.getDepositSize().getFlooredAmount(r);
                float yaw = r.nextFloat() * (float)Math.PI;
                float sizeF = size;
                float startX = (float)posX + TrigMath.sin((double)yaw) * sizeF / 8.0f;
                float endX = (float)posX - TrigMath.sin((double)yaw) * sizeF / 8.0f;
                float startZ = (float)posZ + TrigMath.cos((double)yaw) * sizeF / 8.0f;
                float endZ = (float)posZ - TrigMath.cos((double)yaw) * sizeF / 8.0f;
                float startY = posY + r.nextInt(3) - 2;
                float endY = posY + r.nextInt(3) - 2;
                for (int i = 0; i < size; ++i) {
                    float progress = (float)i / sizeF;
                    float centerX = startX + (endX - startX) * progress;
                    float centerY = startY + (endY - startY) * progress;
                    float centerZ = startZ + (endZ - startZ) * progress;
                    float radius = ((TrigMath.sin((double)((float)Math.PI * progress)) + 1.0f) * r.nextFloat() * sizeF / 16.0f + 1.0f) / 2.0f;
                    float radius2 = MathUtil.squared(radius);
                    int fromX = GenericMath.floor((float)(centerX - radius));
                    int fromY = Math.max(GenericMath.floor((float)(centerY - radius)), worldMinY);
                    int fromZ = GenericMath.floor((float)(centerZ - radius));
                    int toX = GenericMath.floor((float)(centerX + radius));
                    int toY = Math.min(GenericMath.floor((float)(centerY + radius)), worldMaxY);
                    int toZ = GenericMath.floor((float)(centerZ + radius));
                    for (int x = fromX; x <= toX; ++x) {
                        float dx2 = MathUtil.squared((float)x + 0.5f - centerX);
                        if (!(dx2 < radius2)) continue;
                        for (int y = fromY; y <= toY; ++y) {
                            float dy2 = MathUtil.squared((float)y + 0.5f - centerY);
                            if (!(dx2 + dy2 < radius2)) continue;
                            for (int z = fromZ; z <= toZ; ++z) {
                                float dz2 = MathUtil.squared((float)z + 0.5f - centerZ);
                                if (!(dx2 + dy2 + dz2 < radius2) || !predicate.test(worldView.getBlock(x, y, z))) continue;
                                if (worldView.isExposed(x, y, z)) {
                                    if (!useDynamism) continue;
                                    worldView.setDynamism(x, y, z, cfg.dynamism);
                                    worldView.setBlock(x, y, z, block);
                                    continue;
                                }
                                worldView.setBlock(x, y, z, block);
                            }
                        }
                    }
                }
            }
        }
    }

    @ConfigSerializable
    public static final class Config {
        public static final TypeToken<Config> TOKEN = TypeToken.of(Config.class);
        @Setting(value="Blocks", comment="Blocks that will be generated by the modifier")
        public BlockSet blocks;
        @Setting(value="Density", comment="The density of generated blocks, between 0.1 and 10")
        public double density = 1.0;
        @Setting(value="Dynamism", comment="The dynamic obfuscation distance, between 0 and 10")
        public int dynamism = 4;
        @Setting(value="MinY", comment="The minimum Y of the section to obfuscate")
        public int minY = 0;
        @Setting(value="MaxY", comment="The maximum Y of the section to obfuscate")
        public int maxY = 128;

        public Immutable toImmutable() {
            return new Immutable(this.blocks.getAll(), this.density, this.dynamism, this.minY, this.maxY);
        }

        public static final class Immutable {
            public final Set<BlockState> blocks;
            public final double density;
            public final int dynamism;
            public final int minY;
            public final int maxY;

            public Immutable(Collection<BlockState> blocks, double density, int dynamism, int minY, int maxY) {
                this.blocks = ImmutableSet.copyOf(blocks);
                this.density = density;
                this.dynamism = dynamism;
                this.minY = minY;
                this.maxY = maxY;
            }
        }
    }
}

