/*
 * Decompiled with CFR 0.152.
 */
package net.smoofyuniverse.mirage.modifier;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.smoofyuniverse.mirage.Mirage;
import net.smoofyuniverse.mirage.api.cache.Signature;
import net.smoofyuniverse.mirage.api.modifier.ChunkModifier;
import net.smoofyuniverse.mirage.api.volume.BlockView;
import net.smoofyuniverse.mirage.api.volume.ChunkView;
import net.smoofyuniverse.mirage.resource.Resources;
import net.smoofyuniverse.mirage.util.MathUtil;
import net.smoofyuniverse.mirage.util.collection.BlockSet;
import net.smoofyuniverse.mirage.util.collection.WeightedList;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.world.storage.WorldProperties;

public class RandomModifier
extends ChunkModifier {
    public RandomModifier() {
        super(Mirage.get(), "Random");
    }

    @Override
    public Object loadConfiguration(ConfigurationNode node, WorldProperties world, String preset) throws ObjectMappingException {
        Config cfg = (Config)node.getValue(Config.TOKEN);
        if (cfg == null) {
            cfg = new Config();
        }
        if (cfg.blocks == null) {
            cfg.blocks = Resources.of(world).getBlocks("ground", "common", "rare");
        }
        if (cfg.replacements == null) {
            cfg.replacements = new HashMap<BlockState, Double>();
            BlockSet set = Resources.of(world).getBlocks("common");
            for (BlockState state : set.getAll()) {
                cfg.replacements.put(state, 1.0);
            }
            cfg.replacements.put(Resources.of(world).getGround(), Math.max((double)cfg.replacements.size(), 1.0));
        }
        cfg.minY = MathUtil.clamp(cfg.minY, 0, 255);
        cfg.maxY = MathUtil.clamp(cfg.maxY, 0, 255);
        if (cfg.minY > cfg.maxY) {
            int t = cfg.minY;
            cfg.minY = cfg.maxY;
            cfg.maxY = t;
        }
        node.setValue(Config.TOKEN, (Object)cfg);
        return cfg.toImmutable();
    }

    @Override
    public void appendSignature(Signature.Builder builder, Object config) {
        Config.Immutable cfg = (Config.Immutable)config;
        builder.append(cfg.blocks).append(cfg.replacements).append(cfg.minY).append(cfg.maxY);
    }

    @Override
    public boolean isReady(ChunkView view, Object config) {
        return view.areNeighborsLoaded();
    }

    @Override
    public void modify(BlockView view, Vector3i min, Vector3i max, Random r, Object config) {
        Config.Immutable cfg = (Config.Immutable)config;
        int maxX = max.getX();
        int maxY = Math.min(max.getY(), cfg.maxY);
        int maxZ = max.getZ();
        for (int y = Math.max(min.getY(), cfg.minY); y <= maxY; ++y) {
            for (int z = min.getZ(); z <= maxZ; ++z) {
                for (int x = min.getX(); x <= maxX; ++x) {
                    BlockState b = view.getBlock(x, y, z);
                    if (b.getType() == BlockTypes.AIR || !cfg.blocks.contains(b) || view.isExposed(x, y, z)) continue;
                    view.setBlock(x, y, z, cfg.replacements.get(r));
                }
            }
        }
    }

    @ConfigSerializable
    public static final class Config {
        public static final TypeToken<Config> TOKEN = TypeToken.of(Config.class);
        @Setting(value="Blocks", comment="Blocks that will be hidden by the modifier")
        public BlockSet blocks;
        @Setting(value="Replacements", comment="Blocks and their weight used to randomly replace hidden blocks")
        public Map<BlockState, Double> replacements;
        @Setting(value="MinY", comment="The minimum Y of the section to obfuscate")
        public int minY = 0;
        @Setting(value="MaxY", comment="The maximum Y of the section to obfuscate")
        public int maxY = 255;

        public Immutable toImmutable() {
            return new Immutable(this.blocks.getAll(), WeightedList.of(this.replacements), this.minY, this.maxY);
        }

        public static final class Immutable {
            public final Set<BlockState> blocks;
            public final WeightedList<BlockState> replacements;
            public final int minY;
            public final int maxY;

            public Immutable(Collection<BlockState> blocks, WeightedList<BlockState> replacements, int minY, int maxY) {
                this.blocks = ImmutableSet.copyOf(blocks);
                this.replacements = replacements;
                this.minY = minY;
                this.maxY = maxY;
            }
        }
    }
}

