/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.handler.runes.EnumRuneDust;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.tileentity.TileEntityRuneBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemRunePattern
extends ItemBase {
    public ItemRunePattern() {
        super("runePattern");
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("runeData")) {
            int[] runeData = stack.func_77978_p().func_74759_k("runeData");
            int[] amount = new int[EnumRuneDust.values().length];
            for (int i = 0; i < runeData.length; ++i) {
                if (runeData[i] == -1) continue;
                int n = runeData[i];
                amount[n] = amount[n] + 1;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < amount.length; ++i) {
                if (amount[i] == 0) continue;
                list.add(Pair.of((Object)((Object)EnumRuneDust.values()[i]), (Object)amount[i]));
            }
            list.sort(new Comparator<Pair<EnumRuneDust, Integer>>(){

                @Override
                public int compare(Pair<EnumRuneDust, Integer> o1, Pair<EnumRuneDust, Integer> o2) {
                    return (Integer)o1.getRight() - (Integer)o2.getRight();
                }
            });
            for (Pair element : Lists.reverse(list)) {
                tooltip.add("- " + element.getRight() + "x " + I18n.func_135052_a((String)("item.runeDust." + ((EnumRuneDust)((Object)element.getLeft())).getName() + ".name"), (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.general.empty", (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (playerIn.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack(Items.field_151121_aF));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack me;
        IBlockState state = worldIn.func_180495_p(pos);
        if (worldIn.func_175623_d(pos.func_177984_a()) && state.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) && (me = player.func_184586_b(hand)).func_77978_p() != null) {
            int[] runeData = me.func_77978_p().func_74759_k("runeData");
            int[][] actualRuneData = new int[4][4];
            boolean anyThing = player.field_71075_bZ.field_75098_d;
            for (int i = 0; i < runeData.length; ++i) {
                int x = i % 4;
                int y = i / 4;
                int runeType = runeData[i];
                if (runeType != -1 && !player.field_71075_bZ.field_75098_d) {
                    boolean available = false;
                    for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                        ItemStack stack = player.field_71071_by.func_70301_a(s);
                        if (stack.func_190926_b() || stack.func_77973_b() != ModItems.runeDust || stack.func_77952_i() != runeType) continue;
                        if (!worldIn.field_72995_K) {
                            stack.func_190918_g(1);
                        }
                        available = true;
                    }
                    if (!available) {
                        runeType = -1;
                    } else {
                        anyThing = true;
                    }
                }
                actualRuneData[x][y] = runeType;
            }
            if (anyThing) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(pos.func_177984_a(), ModBlocks.runeBase.func_176223_P());
                    TileEntityRuneBase te = (TileEntityRuneBase)worldIn.func_175625_s(pos.func_177984_a());
                    te.setRuneData(actualRuneData);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }
}

