/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.recipes.imbuing;

import java.util.ArrayList;
import java.util.HashMap;
import lumien.randomthings.util.ItemUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ImbuingRecipe {
    ItemStack toImbue;
    ArrayList<ItemStack> ingredients;
    ItemStack result;

    public ImbuingRecipe(ItemStack toImbue, ItemStack result, ItemStack ... ingredients) {
        this.toImbue = toImbue;
        this.ingredients = new ArrayList();
        this.result = result;
        for (ItemStack is : ingredients) {
            if (is.func_190926_b()) continue;
            this.ingredients.add(is);
        }
    }

    public boolean matchesItemHandler(IItemHandler iItemHandler) {
        HashMap<ItemStack, Boolean> providedIngredients = new HashMap<ItemStack, Boolean>();
        ItemStack i1 = iItemHandler.getStackInSlot(0);
        ItemStack i2 = iItemHandler.getStackInSlot(1);
        ItemStack i3 = iItemHandler.getStackInSlot(2);
        ItemStack center = iItemHandler.getStackInSlot(3);
        providedIngredients.put(i1, false);
        providedIngredients.put(i2, false);
        providedIngredients.put(i3, false);
        if (!ItemUtil.areItemStackContentEqual(center, this.toImbue) && !ItemUtil.areOreDictionaried(center, this.toImbue)) {
            return false;
        }
        for (ItemStack needed : this.ingredients) {
            if (this.containsItemStack(providedIngredients, needed)) continue;
            return false;
        }
        for (ItemStack is : providedIngredients.keySet()) {
            if (providedIngredients.get(is).booleanValue() || is.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAsIngredient(ItemStack is) {
        if (ItemUtil.areItemStackContentEqual(this.toImbue, is) || ItemUtil.areOreDictionaried(this.toImbue, is)) {
            return true;
        }
        for (ItemStack ingredient : this.ingredients) {
            if (!ItemUtil.areItemStackContentEqual(ingredient, is) && !ItemUtil.areOreDictionaried(ingredient, is)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItemStack(HashMap<ItemStack, Boolean> list, ItemStack is) {
        for (ItemStack testItemStack : list.keySet()) {
            if (!ItemUtil.areItemStackContentEqual(testItemStack, is) && !ItemUtil.areOreDictionaried(testItemStack, is)) continue;
            list.put(testItemStack, true);
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public ItemStack toImbue() {
        return this.toImbue;
    }

    public ItemStack getResult() {
        return this.result;
    }
}

