/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api.service;

public final class NucleusAPIMetaService {
    private final String version;
    private final String semver;
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;
    private final boolean release;

    public NucleusAPIMetaService(String version, String semver, boolean isRelease) {
        this.version = version;
        this.semver = semver;
        String[] sp = semver.split("\\.", 3);
        this.majorVersion = this.parse(sp[0]);
        this.minorVersion = this.parse(sp[1]);
        this.patchVersion = this.parse(sp[2]);
        this.release = isRelease;
    }

    public String version() {
        return this.version;
    }

    public String semanticVersion() {
        return this.semver;
    }

    public int major() {
        return this.majorVersion;
    }

    public int minor() {
        return this.minorVersion;
    }

    public int patch() {
        return this.patchVersion;
    }

    public boolean isRelease() {
        return this.release;
    }

    private int parse(String string) {
        try {
            return Integer.parseUnsignedInt(string);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

