/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal.data;

import io.github.nucleuspowered.nucleus.api.nucleusdata.TimedEntry;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.Setting;

public abstract class EndTimestamp
implements TimedEntry {
    @Setting
    protected Long endtimestamp;
    @Setting
    protected Long timeFromNextLogin;

    public Optional<Instant> getEndTimestamp() {
        if (this.endtimestamp == null) {
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochSecond(this.endtimestamp));
    }

    public Optional<Duration> getTimeFromNextLogin() {
        if (this.timeFromNextLogin == null) {
            return Optional.empty();
        }
        return Optional.of(Duration.of(this.timeFromNextLogin, ChronoUnit.SECONDS));
    }

    public void setEndtimestamp(Instant time) {
        this.endtimestamp = time.getEpochSecond();
        this.timeFromNextLogin = null;
    }

    public void setTimeFromNextLogin(Duration duration) {
        this.timeFromNextLogin = duration.getSeconds();
        this.endtimestamp = null;
    }

    public void nextLoginToTimestamp() {
        if (this.timeFromNextLogin != null && this.endtimestamp == null) {
            this.endtimestamp = Instant.now().plus((long)this.timeFromNextLogin, ChronoUnit.SECONDS).getEpochSecond();
            this.timeFromNextLogin = null;
        }
    }

    @Override
    public Optional<Duration> getRemainingTime() {
        if (this.endtimestamp == null && this.timeFromNextLogin == null) {
            return Optional.empty();
        }
        Duration duration = this.endtimestamp != null ? Duration.between(Instant.now(), Instant.ofEpochSecond(this.endtimestamp)) : Duration.of(this.timeFromNextLogin, ChronoUnit.SECONDS);
        if (duration.isNegative()) {
            return Optional.of(Duration.ZERO);
        }
        return Optional.of(duration);
    }

    @Override
    public boolean expired() {
        return this.getRemainingTime().map(Duration::isZero).orElse(false);
    }

    @Override
    public boolean isCurrentlyTicking() {
        return this.endtimestamp != null;
    }
}

