/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Scan;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.modules.core.commands.NucleusCommand;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.UniqueUserCountTransientModule;
import java.util.Collection;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Scan
@NonnullByDefault
@Permissions(prefix="nucleus")
@RegisterCommand(value={"debug"}, subcommandOf=NucleusCommand.class, hasExecutor=false)
public class DebugCommand
extends AbstractCommand<CommandSource> {
    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        return CommandResult.empty();
    }

    @Permissions(prefix="nucleus.debug")
    @NoModifiers
    @RegisterCommand(value={"refreshuniquevisitors"}, subcommandOf=DebugCommand.class)
    public static class RefreshUniqueVisitors
    extends AbstractCommand<CommandSource> {
        @Override
        protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.debug.refreshuniquevisitors.started", String.valueOf(Nucleus.getNucleus().getGeneralService().getTransient(UniqueUserCountTransientModule.class).getUniqueUserCount())));
            Nucleus.getNucleus().getGeneralService().getTransient(UniqueUserCountTransientModule.class).resetUniqueUserCount(l -> src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.debug.refreshuniquevisitors.done", String.valueOf(l))));
            return CommandResult.success();
        }
    }

    @Permissions(prefix="nucleus.debug")
    @NoModifiers
    @RegisterCommand(value={"getuuids"}, subcommandOf=DebugCommand.class)
    public static class GetUUIDSCommand
    extends AbstractCommand<CommandSource> {
        @Override
        public CommandElement[] getArguments() {
            return new CommandElement[]{NucleusParameters.MANY_USER_NO_SELECTOR};
        }

        @Override
        protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
            Collection users = args.getAll("user");
            if (users.isEmpty()) {
                throw ReturnMessageException.fromKey("command.nucleus.debug.uuid.none", new Object[0]);
            }
            MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
            Util.getPaginationBuilder(src).title(provider.getTextMessageWithFormat("command.nucleus.debug.uuid.title", ((User)users.iterator().next()).getName())).header(provider.getTextMessageWithFormat("command.nucleus.debug.uuid.header", new String[0])).contents((Iterable)users.stream().map(x -> Text.builder((String)x.getUniqueId().toString()).color(x.isOnline() ? TextColors.GREEN : TextColors.RED).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.debug.uuid.clicktodelete", new String[0]))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus resetuser -a " + x.getUniqueId().toString()))).build()).collect(Collectors.toList())).sendTo((MessageReceiver)src);
            return CommandResult.success();
        }
    }

    @NonnullByDefault
    @Permissions(prefix="nucleus.debug")
    @RegisterCommand(value={"setsession"}, subcommandOf=DebugCommand.class)
    public static class SetSession
    extends AbstractCommand<CommandSource> {
        @Override
        public CommandElement[] getArguments() {
            return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
        }

        @Override
        protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
            boolean set = args.getOne("true|false").orElseGet(() -> !Nucleus.getNucleus().isSessionDebug());
            Nucleus.getNucleus().setSessionDebug(set);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.debug.setsession", String.valueOf(set)));
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.debug.setsession2", new String[0]));
            return CommandResult.success();
        }
    }
}

