/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.environment.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.WorldTimeArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.modules.environment.commands.TimeCommand;
import java.util.function.LongFunction;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="time")
@RegisterCommand(value={"set"}, subcommandOf=TimeCommand.class, rootAliasRegister={"settime", "timeset"})
@EssentialsEquivalent(value={"time", "day", "night"}, isExact=false, notes="A time MUST be specified.")
@NonnullByDefault
public class SetTimeCommand
extends AbstractCommand<CommandSource> {
    private final String time = "time";
    private final String world = "world";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.world((Text)Text.of((String)this.world)))), GenericArguments.onlyOne((CommandElement)new WorldTimeArgument((Text)Text.of((String)this.time)))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        WorldProperties pr = this.getWorldPropertiesOrDefault(src, this.world, args);
        LongFunction tick = (LongFunction)args.getOne(this.time).get();
        long time = (Long)tick.apply(pr.getWorldTime());
        pr.setWorldTime(time);
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.settime.done2", pr.getWorldName(), String.valueOf(Util.getTimeFromTicks(time))));
        return CommandResult.success();
    }
}

