/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.freezeplayer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularUserService;
import io.github.nucleuspowered.nucleus.internal.qsml.module.StandardModule;
import io.github.nucleuspowered.nucleus.internal.text.Tokens;
import io.github.nucleuspowered.nucleus.modules.freezeplayer.commands.FreezePlayerCommand;
import io.github.nucleuspowered.nucleus.modules.freezeplayer.datamodules.FreezePlayerUserDataModule;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.annotations.ModuleData;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@ModuleData(id="freeze-subject", name="Freeze Player")
public class FreezePlayerModule
extends StandardModule {
    @Override
    public void performEnableTasks() {
        this.createSeenModule(FreezePlayerCommand.class, (CommandSource c, User u) -> {
            Optional<ModularUserService> us = Nucleus.getNucleus().getUserDataManager().get((User)u);
            if (us.isPresent() && us.get().get(FreezePlayerUserDataModule.class).isFrozen()) {
                return Lists.newArrayList((Object[])new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("seen.frozen", new String[0])});
            }
            return Lists.newArrayList((Object[])new Text[]{Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("seen.notfrozen", new String[0])});
        });
    }

    @Override
    protected Map<String, Tokens.Translator> tokensToRegister() {
        return ImmutableMap.builder().put((Object)"frozen", (Object)new Tokens.TrueFalseVariableTranslator(){
            final Optional<Text> def = Optional.of(Text.of((Object[])new Object[]{TextColors.GRAY, "[Frozen]"}));

            @Override
            protected Optional<Text> getDefault() {
                return this.def;
            }

            @Override
            protected boolean condition(CommandSource commandSource) {
                return commandSource instanceof Player && Nucleus.getNucleus().getUserDataManager().get((User)commandSource).map(x -> x.get(FreezePlayerUserDataModule.class).isFrozen()).orElse(false) != false;
            }
        }).build();
    }
}

