/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.inventory.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.Since;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.inventory.config.InventoryConfig;
import io.github.nucleuspowered.nucleus.modules.inventory.config.InventoryConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.inventory.listeners.InvSeeListener;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NoModifiers
@Permissions
@RegisterCommand(value={"invsee"})
@EssentialsEquivalent(value={"invsee"})
@Since(minecraftVersion="1.10.2", spongeApiVersion="5.0.0", nucleusVersion="0.13.0")
@NonnullByDefault
public class InvSeeCommand
extends AbstractCommand<Player>
implements Reloadable {
    private boolean self = false;

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        Map<String, PermissionInformation> mspi = super.permissionSuffixesToRegister();
        mspi.put("exempt.target", PermissionInformation.getWithTranslation("permission.invsee.exempt.inspect", SuggestedLevel.ADMIN));
        mspi.put("exempt.interact", PermissionInformation.getWithTranslation("permission.invsee.exempt.interact", SuggestedLevel.ADMIN));
        mspi.put("modify", PermissionInformation.getWithTranslation("permission.invsee.modify", SuggestedLevel.ADMIN));
        mspi.put("offline", PermissionInformation.getWithTranslation("permission.invsee.offline", SuggestedLevel.ADMIN));
        return mspi;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.ONE_USER};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        User target = (User)args.getOne("user").get();
        if (!target.isOnline() && !this.permissions.testSuffix((Subject)src, "offline")) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.invsee.nooffline", new String[0]));
        }
        if (!this.self && target.getUniqueId().equals(src.getUniqueId())) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.invsee.self", new String[0]));
        }
        if (this.permissions.testSuffix((Subject)target, "exempt.target", (CommandSource)src, false)) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.invsee.targetexempt", target.getName()));
        }
        try {
            CarriedInventory targetInv = target.isOnline() ? ((Player)target.getPlayer().get()).getInventory() : target.getInventory();
            Optional oc = src.openInventory((Inventory)targetInv);
            if (oc.isPresent()) {
                if (!this.permissions.testSuffix((Subject)src, "modify") || this.permissions.testSuffix((Subject)target, "exempt.interact")) {
                    InvSeeListener.addEntry(src.getUniqueId(), (Container)oc.get());
                }
                return CommandResult.success();
            }
            throw ReturnMessageException.fromKey("command.invsee.failed", new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            throw ReturnMessageException.fromKey("command.invsee.offlinenotsupported", new Object[0]);
        }
    }

    @Override
    public void onReload() {
        this.self = Nucleus.getNucleus().getConfigValue("inventory", InventoryConfigAdapter.class, InventoryConfig::isAllowInvseeOnSelf).orElse(false);
    }
}

