/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands.lore;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import java.util.List;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.LoreData;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
abstract class LoreModifyBaseCommand
extends AbstractCommand<Player> {
    final String loreLine = "line";

    LoreModifyBaseCommand() {
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{new PositiveIntegerArgument((Text)Text.of((String)this.loreLine), false), NucleusParameters.LORE};
    }

    CommandResult setLore(Player src, String message, int line, boolean editOrInsert) throws Exception {
        --line;
        ItemStack stack = (ItemStack)src.getItemInHand(HandTypes.MAIN_HAND).orElseThrow(() -> ReturnMessageException.fromKey("command.lore.set.noitem", new Object[0]));
        LoreData loreData = (LoreData)stack.getOrCreate(LoreData.class).get();
        Text getLore = TextSerializers.FORMATTING_CODE.deserialize(message);
        List loreList = (List)loreData.lore().get();
        if (editOrInsert) {
            if (loreList.size() < line) {
                throw ReturnMessageException.fromKey("command.lore.set.invalidEdit", new Object[0]);
            }
            loreList.set(line, getLore);
        } else if (loreList.size() < line) {
            loreList.add(getLore);
        } else {
            loreList.add(line, getLore);
        }
        if (stack.offer(Keys.ITEM_LORE, (Object)loreList).isSuccessful()) {
            src.setItemInHand(HandTypes.MAIN_HAND, stack);
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.lore.set.success", new String[0]));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.lore.set.fail", new Object[0]);
    }
}

