/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.listeners;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.traits.InternalServiceManagerTrait;
import io.github.nucleuspowered.nucleus.modules.nickname.datamodules.NicknameUserDataModule;
import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import java.util.Optional;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;

public class NicknameListener
implements ListenerBase,
InternalServiceManagerTrait {
    @Listener(order=Order.FIRST)
    public void onPlayerJoin(ClientConnectionEvent.Join event, @Root Player player) {
        Nucleus.getNucleus().getUserDataManager().get((User)player).ifPresent(x -> {
            Optional<Text> d = x.get(NicknameUserDataModule.class).getNicknameAsText();
            d.ifPresent(text -> this.getServiceUnchecked(NicknameService.class).updateCache(player.getUniqueId(), (Text)text));
            player.offer(Keys.DISPLAY_NAME, (Object)d.orElseGet(() -> Text.of((String)player.getName())));
        });
    }

    @Listener(order=Order.LAST)
    public void onPlayerQuit(ClientConnectionEvent.Disconnect event, @Root Player player) {
        this.getServiceUnchecked(NicknameService.class).removeFromCache(player.getUniqueId());
    }
}

