/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.userprefs.UserPreferenceService;
import io.github.nucleuspowered.nucleus.modules.teleport.TeleportUserPrefKeys;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(prefix="teleport", suggestedLevel=SuggestedLevel.USER)
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"tptoggle"})
@RunAsync
@EssentialsEquivalent(value={"tptoggle"})
public class TeleportToggleCommand
extends AbstractCommand<Player> {
    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("exempt", PermissionInformation.getWithTranslation("permission.tptoggle.exempt", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) {
        UserPreferenceService ups = (UserPreferenceService)this.getServiceUnchecked(UserPreferenceService.class);
        boolean toggle = ups.get(src.getUniqueId(), TeleportUserPrefKeys.TELEPORT_TARGETABLE).get();
        boolean flip = args.getOne("true|false").orElseGet(() -> !toggle);
        ups.set(src.getUniqueId(), TeleportUserPrefKeys.TELEPORT_TARGETABLE, flip);
        src.sendMessage(Text.builder().append(new Text[]{this.getMessageFor((CommandSource)src, "command.tptoggle.success", new Text[]{this.getMessageFor((CommandSource)src, flip ? "standard.enabled" : "standard.disabled")})}).build());
        return CommandResult.success();
    }
}

