/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warn.listeners;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.warn.config.WarnConfig;
import io.github.nucleuspowered.nucleus.modules.warn.config.WarnConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.warn.data.WarnData;
import io.github.nucleuspowered.nucleus.modules.warn.services.WarnHandler;
import io.github.nucleuspowered.nucleus.util.PermissionMessageChannel;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MutableMessageChannel;

public class WarnListener
implements Reloadable,
ListenerBase {
    private final WarnHandler handler = this.getServiceUnchecked(WarnHandler.class);
    private final String showOnLogin = "nucleus.warn.showonlogin";
    private boolean isShowOnLogin = true;

    @Listener
    public void onPlayerLogin(ClientConnectionEvent.Join event) {
        Sponge.getScheduler().createTaskBuilder().async().delay(500L, TimeUnit.MILLISECONDS).execute(() -> {
            Player player = event.getTargetEntity();
            List<WarnData> warnings = this.handler.getWarningsInternal((User)player, true, false);
            if (warnings != null && !warnings.isEmpty()) {
                List lwd;
                for (WarnData warning : warnings) {
                    warning.nextLoginToTimestamp();
                    if (warning.getEndTimestamp().isPresent() && warning.getEndTimestamp().get().isBefore(Instant.now())) {
                        this.handler.removeWarning((User)player, warning);
                        continue;
                    }
                    if (!this.isShowOnLogin) continue;
                    if (warning.getEndTimestamp().isPresent()) {
                        player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("warn.playernotify.time", warning.getReason(), Util.getTimeStringFromSeconds(Instant.now().until(warning.getEndTimestamp().get(), ChronoUnit.SECONDS))));
                        continue;
                    }
                    player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("warn.playernotify.standard", warning.getReason()));
                }
                if (this.isShowOnLogin && !(lwd = warnings.stream().filter(x -> !x.isExpired()).collect(Collectors.toList())).isEmpty()) {
                    MutableMessageChannel messageChannel = new PermissionMessageChannel(this.showOnLogin).asMutable();
                    messageChannel.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("warn.login.notify", player.getName(), String.valueOf(lwd.size())).toBuilder().onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("warn.login.view", player.getName()))).onClick((ClickAction)TextActions.runCommand((String)("/checkwarnings " + player.getName()))).build());
                }
            }
        }).submit((Object)Nucleus.getNucleus());
    }

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap mp = Maps.newHashMap();
        mp.put(this.showOnLogin, PermissionInformation.getWithTranslation("permission.warn.showonlogin", SuggestedLevel.MOD));
        return mp;
    }

    @Override
    public void onReload() {
        this.isShowOnLogin = ((WarnConfig)this.getServiceUnchecked(WarnConfigAdapter.class).getNodeOrDefault()).isShowOnLogin();
    }
}

