/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.listeners;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfigAdapter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.world.World;

public class EnforceGamemodeListener
implements ListenerBase.Conditional {
    private final String perm = "nucleus.world.force-gamemode.override";

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        return ImmutableMap.of((Object)this.perm, (Object)PermissionInformation.getWithTranslation("permission.world.force-gamemode.override", SuggestedLevel.ADMIN));
    }

    @Listener(order=Order.POST)
    public void onPlayerLogin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        Task.builder().execute(() -> this.enforce(player, player.getWorld())).submit((Object)Nucleus.getNucleus());
    }

    @Listener(order=Order.POST)
    public void onPlayerTeleport(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player player, @Getter(value="getFromTransform") Transform<World> from, @Getter(value="getToTransform") Transform<World> to) {
        if (!((World)from.getExtent()).getUniqueId().equals(((World)to.getExtent()).getUniqueId())) {
            this.enforce(player, (World)to.getExtent());
        }
    }

    private void enforce(Player player, World world) {
        if (world.getProperties().getGameMode() == GameModes.NOT_SET) {
            return;
        }
        HashSet contextSet = Sets.newHashSet((Iterable)player.getActiveContexts());
        contextSet.removeIf(x -> x.getKey().equals("world"));
        contextSet.add(new Context("world", world.getName()));
        if (!player.hasPermission((Set)contextSet, this.perm)) {
            player.offer(Keys.GAME_MODE, (Object)world.getProperties().getGameMode());
        }
    }

    @Override
    public boolean shouldEnable() {
        return Nucleus.getNucleus().getConfigValue("world", WorldConfigAdapter.class, WorldConfig::isEnforceGamemodeOnWorldChange).orElse(false);
    }
}

