/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.commands.subcommands.laggychunks.EntitiesCommand;
import me.time6628.clag.sponge.commands.subcommands.laggychunks.TilesCommand;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.blockray.BlockRay;
import org.spongepowered.api.util.blockray.BlockRayHit;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class LaggyChunksCommand
implements CommandExecutor {
    private final CatClearLag plugin = CatClearLag.instance;

    public static CommandSpec getCommand() {
        return CommandSpec.builder().description((Text)Text.of((String)"List chunks in order of most to least entities or tiles.")).permission("catclearlag.command.laggychunks").executor((CommandExecutor)new LaggyChunksCommand()).child((CommandCallable)EntitiesCommand.getCommand(), new String[]{"entities", "e"}).child((CommandCallable)TilesCommand.getCommand(), new String[]{"tiles", "t"}).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) {
        this.plugin.getPaginationService().builder().contents(this.getCommands()).title(Text.builder().color(TextColors.LIGHT_PURPLE).append(new Text[]{Text.of((String)"Commands")}).build()).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    protected ClickAction.ExecuteCallback callback(Chunk chunk) {
        return TextActions.executeCallback(commandSource -> {
            if (commandSource instanceof ConsoleSource) {
                commandSource.sendMessage((Text)Text.of((String)(TextColors.RED + "Silly console, you can't teleport.")));
                return;
            }
            Player player = (Player)commandSource;
            Location a = new Location((Extent)chunk.getWorld(), chunk.getPosition());
            Location b = new Location(a.getExtent(), a.getX() * 16.0 + 8.0, (double)((World)a.getExtent()).getBlockMax().getY(), a.getZ() * 16.0 + 8.0);
            Optional c = BlockRay.from((Location)b).stopFilter(BlockRay.onlyAirFilter()).to(a.getPosition().sub(b.getX(), 1.0, b.getZ())).end();
            if (c.isPresent()) {
                BlockRayHit d = (BlockRayHit)c.get();
                player.setLocation(d.getLocation());
            } else {
                commandSource.sendMessage((Text)Text.of((String)("Could not send you to: " + a.getX() + "," + a.getZ())));
            }
        });
    }

    private List<Text> getCommands() {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().onClick((ClickAction)TextActions.suggestCommand((String)"/lc tiles")).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Search for chunks with lots of tiles."))).append(new Text[]{Text.of((String)"/lc tiles")}).build());
        texts.add(Text.builder().onClick((ClickAction)TextActions.suggestCommand((String)"/lc entities")).onHover((HoverAction)TextActions.showText((Text)Text.of((String)"Search for chunks with lots of entities."))).append(new Text[]{Text.of((String)"/lc entities")}).build());
        return texts;
    }
}

