/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.EntityRemover;
import me.time6628.clag.sponge.Messages;
import me.time6628.clag.sponge.api.Type;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class RemoveEntitiesCommand
implements CommandExecutor {
    private final CatClearLag plugin = CatClearLag.instance;

    public static CommandSpec getCommand() {
        return CommandSpec.builder().description((Text)Text.of((String)"Remove various types of entities.")).permission("catclearlag.command.remove").arguments(GenericArguments.flags().permissionFlag("catclearlag.command.remove.hostile", new String[]{"h", "-hostile"}).permissionFlag("catclearlag.command.remove.all", new String[]{"a", "-all"}).permissionFlag("catclearlag.command.remove.items", new String[]{"i", "-item"}).permissionFlag("catclearlag.command.remove.living", new String[]{"l", "-living"}).permissionFlag("catclearlag.command.remove.xp", new String[]{"x", "-xp"}).permissionFlag("catclearlag.command.remove.passive", new String[]{"p", "-passive"}).permissionFlag("catclearlag.command.remove.named", new String[]{"n", "-named"}).permissionFlag("catclearlag.command.remove.animal", new String[]{"m", "-animal"}).buildWith(GenericArguments.none())).executor((CommandExecutor)new RemoveEntitiesCommand()).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) {
        if (args.hasAny("a") || args.hasAny("h") || args.hasAny("i") || args.hasAny("x") || args.hasAny("l") || args.hasAny("n") || args.hasAny("m")) {
            Predicate<Entity> pred = null;
            if (args.hasAny("a")) {
                pred = this.combinePred(pred, Type.ALL);
            }
            if (args.hasAny("h")) {
                pred = this.combinePred(pred, Type.HOSTILE);
            }
            if (args.hasAny("i")) {
                pred = this.combinePred(pred, Type.ITEM);
            }
            if (args.hasAny("x")) {
                pred = this.combinePred(pred, Type.XP);
            }
            if (args.hasAny("l")) {
                pred = this.combinePred(pred, Type.LIVING);
            }
            if (args.hasAny("m")) {
                pred = this.combinePred(pred, Type.ANIMAL);
            }
            if (args.hasAny("n")) {
                pred = this.combinePred(pred, Type.NAMED);
            }
            EntityRemover remover = new EntityRemover(pred);
            src.sendMessage(Text.builder().append(new Text[]{Messages.getPrefix()}).append(new Text[]{Messages.colorMessage("Removing entities...")}).build());
            int affectedEnts = remover.removeEntities();
            src.sendMessage(Text.builder().append(new Text[]{Messages.getPrefix()}).append(new Text[]{Messages.colorMessage(affectedEnts + " entities removed.")}).build());
            return CommandResult.affectedEntities((int)affectedEnts);
        }
        this.plugin.getPaginationService().builder().contents(this.getFlags()).title(Text.builder().color(TextColors.LIGHT_PURPLE).append(new Text[]{Text.of((String)"/re Help")}).build()).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private List<Text> getFlags() {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(this.ez("/re -a", "Remove all entities."));
        texts.add(this.ez("/re -h", "Remove all hostiles."));
        texts.add(this.ez("/re -i", "Remove all items."));
        texts.add(this.ez("/re -x", "Remove all XP Orbs."));
        texts.add(this.ez("/re -l", "Remove all living entities."));
        texts.add(this.ez("/re -m", "Remove all animals."));
        texts.add(this.ez("/re -n", "Prevents name tagged entities from being removed."));
        return texts;
    }

    private Text ez(String cmd, String desc) {
        return Text.builder().onClick((ClickAction)TextActions.suggestCommand((String)cmd)).append(new Text[]{Text.of((String)cmd)}).append(new Text[]{Text.of((String)(" - " + desc))}).build();
    }

    private Predicate<Entity> combinePred(Predicate<Entity> pred, Type type) {
        if (pred == null) {
            return this.plugin.getCclService().getPredicate(type);
        }
        return pred.or(this.plugin.getCclService().getPredicate(type));
    }
}

