/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.method;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.executor.BasicExecutor;
import org.squiddev.plethora.integration.MetaWrapper;

public final class ContextHelpers {
    private ContextHelpers() {
    }

    @Nonnull
    public static <T> Map<Integer, TypedMeta<T, ?>> getMetaList(@Nonnull IPartialContext<?> context, @Nullable Collection<T> list) {
        if (list == null) {
            return Collections.emptyMap();
        }
        LuaList out = new LuaList(list.size());
        for (T element : list) {
            out.add(element == null ? null : context.makePartialChild(element).getMeta());
        }
        return out.asMap();
    }

    @Nonnull
    public static <T> Map<Integer, TypedMeta<T, ?>> getMetaList(@Nonnull IPartialContext<?> context, @Nullable T[] list) {
        if (list == null) {
            return Collections.emptyMap();
        }
        HashMap map = new HashMap(list.length);
        for (int i = 0; i < list.length; ++i) {
            T element = list[i];
            if (element == null) continue;
            map.put(i + 1, context.makePartialChild(element).getMeta());
        }
        return map;
    }

    @Nonnull
    public static <T> Map<Integer, TypedLuaObject<T>> getObjectList(@Nonnull IContext<?> context, @Nullable Collection<T> list) {
        if (list == null) {
            return Collections.emptyMap();
        }
        int i = 0;
        HashMap<Integer, TypedLuaObject<T>> map = new HashMap<Integer, TypedLuaObject<T>>(list.size());
        for (T element : list) {
            if (element == null) {
                ++i;
                continue;
            }
            map.put(++i, context.makeChildId(element).getObject());
            map.put(++i, context.makeChild(element, Reference.id(element)).getObject());
        }
        return map;
    }

    @Nullable
    public static TypedLuaObject<MetaWrapper<ItemStack>> wrapStack(@Nonnull IPartialContext<?> context, @Nullable ItemStack object) {
        if (object == null || object.func_190926_b()) {
            return null;
        }
        MetaWrapper<ItemStack> wrapper = MetaWrapper.of(object.func_77946_l());
        return context instanceof IContext ? ((IContext)context).makeChildId(wrapper).getObject() : ContextFactory.of(wrapper).withExecutor(BasicExecutor.INSTANCE).getObject();
    }
}

