/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.converter.IConverter;
import org.squiddev.plethora.api.converter.IConverterRegistry;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.core.ConverterReference;
import org.squiddev.plethora.core.collections.ClassIteratorIterable;

public class ConverterRegistry
implements IConverterRegistry {
    public static final ConverterRegistry instance = new ConverterRegistry();
    private final Multimap<Class<?>, IConverter<?, ?>> converters = MultimapBuilder.hashKeys().hashSetValues().build();

    <TIn, TOut> void registerConverter(@Nonnull Class<TIn> source, @Nonnull IConverter<TIn, TOut> converter) {
        Objects.requireNonNull(source, "source cannot be null");
        Objects.requireNonNull(converter, "converter cannot be null");
        this.converters.put(source, converter);
    }

    @Nonnull
    public Iterable<Object> convertAll(final @Nonnull Object input) {
        Objects.requireNonNull(input, "input cannot be null");
        return new Iterable<Object>(){

            @Override
            @Nonnull
            public Iterator<Object> iterator() {
                return new ConverterIterator(input);
            }
        };
    }

    public void extendConverted(@Nonnull List<String> keys, @Nonnull List<Object> values, @Nonnull List<Object> references, int startPoint) {
        int i;
        Objects.requireNonNull(keys, "keys cannot be null");
        Objects.requireNonNull(values, "values cannot be null");
        Objects.requireNonNull(references, "references in cannot be null");
        if (keys.size() != values.size()) {
            throw new IllegalStateException("lists must be of the same size");
        }
        if (keys.size() != references.size()) {
            throw new IllegalStateException("lists must be of the same size");
        }
        Object2IntOpenHashMap positions = new Object2IntOpenHashMap();
        positions.defaultReturnValue(-1);
        for (i = 0; i < values.size(); ++i) {
            positions.put(values.get(i), i);
        }
        for (i = startPoint; i < values.size(); ++i) {
            Object target = values.get(i);
            Class<?> initial = target.getClass();
            for (Class<?> klass : new ClassIteratorIterable(initial)) {
                for (IConverter converter : this.converters.get(klass)) {
                    Object converted = converter.convert(target);
                    if (converted == null) continue;
                    int existing = positions.getInt(converted);
                    if (existing == positions.defaultReturnValue()) {
                        positions.put(converted, keys.size());
                        keys.add(keys.get(i));
                        values.add(converted);
                        boolean isConstant = converter.isConstant();
                        if (isConstant) {
                            Object reference = references.get(i);
                            if (reference instanceof ConverterReference) {
                                isConstant = false;
                            } else if (reference instanceof IReference) {
                                isConstant = ((IReference)reference).isConstant();
                            }
                        }
                        references.add(isConstant ? converted : new ConverterReference(i, klass, converter));
                        continue;
                    }
                    if (!ConverterRegistry.requiresInsertion(keys, values, existing, keys.get(i), converted)) continue;
                    positions.put(converted, keys.size());
                    keys.add(keys.get(i));
                    values.add(converted);
                    Object reference = references.get(existing);
                    references.add(reference instanceof ConverterReference && ((ConverterReference)reference).isIdentity() ? reference : ConverterReference.identity(existing));
                }
            }
        }
    }

    public void extendConverted(@Nonnull List<String> keys, @Nonnull List<Object> values, int startPoint) {
        int i;
        Objects.requireNonNull(keys, "keys cannot be null");
        Objects.requireNonNull(values, "values cannot be null");
        if (keys.size() != values.size()) {
            throw new IllegalStateException("lists must be of the same size");
        }
        Object2IntOpenHashMap positions = new Object2IntOpenHashMap();
        positions.defaultReturnValue(-1);
        for (i = 0; i < values.size(); ++i) {
            positions.put(values.get(i), i);
        }
        for (i = startPoint; i < values.size(); ++i) {
            Object target = values.get(i);
            Class<?> initial = target.getClass();
            for (Class<?> klass : new ClassIteratorIterable(initial)) {
                for (IConverter converter : this.converters.get(klass)) {
                    int existing;
                    Object converted = converter.convert(target);
                    if (converted == null || (existing = positions.getInt(converted)) != positions.defaultReturnValue() && !ConverterRegistry.requiresInsertion(keys, values, existing, keys.get(i), converted)) continue;
                    positions.put(converted, keys.size());
                    keys.add(keys.get(i));
                    values.add(converted);
                }
            }
        }
    }

    private static boolean requiresInsertion(List<String> keys, List<Object> values, int existing, String key, Object value) {
        for (int i = existing; i >= 0; --i) {
            if (!values.get(i).equals(value) || !keys.get(i).equals(key)) continue;
            return false;
        }
        return true;
    }

    private class ConverterIterator
    implements Iterator<Object> {
        private final Set<Object> allConverted = new HashSet<Object>();
        private final Queue<Object> queue = new ArrayDeque<Object>();

        ConverterIterator(Object input) {
            this.allConverted.add(input);
            this.queue.offer(input);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public Object next() {
            Object next = this.queue.remove();
            Class<?> initial = next.getClass();
            for (Class<?> klass : new ClassIteratorIterable(initial)) {
                for (IConverter converter : ConverterRegistry.this.converters.get(klass)) {
                    Object converted = converter.convert(next);
                    if (converted == null || !this.allConverted.add(converted)) continue;
                    this.queue.offer(converted);
                }
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

